package VC71WorkspaceCreator;

# ************************************************************
# Description   : A VC7.1 Workspace Creator
# Author        : Chad Elliott
# Create Date   : 4/17/2003
# ************************************************************

# ************************************************************
# Pragmas
# ************************************************************

use strict;

use VC71ProjectCreator;
use VC7WorkspaceCreator;

use vars qw(@ISA);
@ISA = qw(VC7WorkspaceCreator);

# ************************************************************
# Subroutine Section
# ************************************************************


sub pre_workspace {
  my($self, $fh) = @_;
  my $crlf = $self->crlf();

  ## This identifies it as a Visual Studio 2003 file
  print $fh 'Microsoft Visual Studio Solution File, Format Version 8.00', $crlf;

  ## Optionally print the workspace comment
  $self->print_workspace_comment($fh,
            '#', $crlf,
            '# This file was generated by MPC.  Any changes made directly to', $crlf,
            '# this file will be lost the next time it is generated.', $crlf,
            '#', $crlf,
            '# MPC Command:', $crlf,
            '# ', $self->create_command_line_string($0, @ARGV), $crlf);
}


sub print_inner_project {
  my($self, $fh, $gen, $pguid, $deps, $project_name, $name_to_guid_map) = @_;

  if ($self->allow_empty_dependencies() || defined $$deps[0]) {
    ## Print out the project dependencies
    my $crlf = $self->crlf();
    print $fh "\tProjectSection(ProjectDependencies) = postProject$crlf";
    foreach my $dep (@$deps) {
      my $guid = $name_to_guid_map->{$dep};
      print $fh "\t\t{$guid} = {$guid}$crlf" if (defined $guid);
    }
    print $fh "\tEndProjectSection$crlf";
  }
}


sub allow_empty_dependencies {
  #my $self = shift;
  return 1;
}


sub print_configs {
  my($self, $fh, $configs) = @_;
  my $crlf = $self->crlf();
  foreach my $key (sort keys %$configs) {
    print $fh "\t\t$key = $key$crlf";
  }
}


sub print_dependencies {
  ## These are done in the print_inner_project method
}


1;
