/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 *  ianjuta-debugger-variable.c -- Autogenerated from libanjuta.idl
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

/**
* SECTION:ianjuta-debugger-variable
* @title: IAnjutaDebuggerVariable
* @short_description: Variables interface for debuggers
* @see_also:
* @stability: Unstable
* @include: libanjuta/interfaces/ianjuta-debugger-variable.h
*
 	* This interface is used to examine and change values of expression.
* It is based on the MI2 variable object interface of gdb. A
* variable needs to be created before being able to get or set its
* value and list its children.
*/

#include "ianjuta-debugger-variable.h"
#include "libanjuta-iface-marshallers.h"

GQuark 
ianjuta_debugger_variable_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-debugger-variable-quark");
	}
	
	return quark;
}

/**
* ianjuta_debugger_variable_assign:
* @obj: Self
* @name: Variable name
* @value: Variable value
* @err: Error propagation and reporting.
*
* Set the value of one variable or child object.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_variable_assign (IAnjutaDebuggerVariable *obj, const gchar *name,   const gchar *value, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_VARIABLE(obj), FALSE);
	return IANJUTA_DEBUGGER_VARIABLE_GET_IFACE (obj)->assign (obj, name, value, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_variable_assign_default (IAnjutaDebuggerVariable *obj, const gchar *name,   const gchar *value, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_variable_create:
* @obj: Self
* @expression: Variable expression
* @callback: Callback to call when the variable has been created
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
*
* Create a new variable object in the current thread and frame.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_variable_create (IAnjutaDebuggerVariable *obj, const gchar *expression,   IAnjutaDebuggerVariableCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_VARIABLE(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_VARIABLE_GET_IFACE (obj)->create (obj, expression, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_variable_create_default (IAnjutaDebuggerVariable *obj, const gchar *expression,   IAnjutaDebuggerVariableCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_variable_destroy:
* @obj: Self
* @name: Variable name
* @err: Error propagation and reporting.
*
* Delete a previously created variable or child object
* including its own children.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_variable_destroy (IAnjutaDebuggerVariable *obj, const gchar *name, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_VARIABLE(obj), FALSE);
	return IANJUTA_DEBUGGER_VARIABLE_GET_IFACE (obj)->destroy (obj, name, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_variable_destroy_default (IAnjutaDebuggerVariable *obj, const gchar *name, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_variable_evaluate:
* @obj: Self
* @name: Variable name
* @callback: Callback to call with the variable value
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
*
* Get the value of one variable or child object.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_variable_evaluate (IAnjutaDebuggerVariable *obj, const gchar *name,   IAnjutaDebuggerGCharCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_VARIABLE(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_VARIABLE_GET_IFACE (obj)->evaluate (obj, name, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_variable_evaluate_default (IAnjutaDebuggerVariable *obj, const gchar *name,   IAnjutaDebuggerGCharCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_variable_list_children:
* @obj: Self
* @name: Variable name
* @from: Starting from this children (zero-based)
* @callback: Callback to call when the children have been
* created with a list of variable objects
* @user_data: User data that is passed back to the callback
 	* @err: Error propagation and reporting.
*
* List and create objects for variable object's children.
* The backend can returns only a part of the children, in
* this case a last variable with a NULL name is added to
* the list given to the callback function.
* If the remaining children are wanted, this
* function must be called again with a from argument
* corresponding to the first missing children.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_variable_list_children (IAnjutaDebuggerVariable *obj, const gchar *name,   guint from,   IAnjutaDebuggerGListCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_VARIABLE(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_VARIABLE_GET_IFACE (obj)->list_children (obj, name, from, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_variable_list_children_default (IAnjutaDebuggerVariable *obj, const gchar *name,   guint from,   IAnjutaDebuggerGListCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

/**
* ianjuta_debugger_variable_update:
* @obj: Self
* @callback: Callback to call with the list of all changed
* variable names
* @user_data: User data that is passed back to the callback
* @err: Error propagation and reporting.
*
* List all changed variable objects since the last call.
*
* Returns: TRUE if the request succeed and the callback is
* called. If FALSE, the callback will not be called.
*/
gboolean
ianjuta_debugger_variable_update (IAnjutaDebuggerVariable *obj, IAnjutaDebuggerGListCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_fail (IANJUTA_IS_DEBUGGER_VARIABLE(obj), FALSE);
	g_return_val_if_fail (user_data != NULL, FALSE);
	return IANJUTA_DEBUGGER_VARIABLE_GET_IFACE (obj)->update (obj, callback, user_data, err);
}

/* Default implementation */
static gboolean
ianjuta_debugger_variable_update_default (IAnjutaDebuggerVariable *obj, IAnjutaDebuggerGListCallback callback,   gpointer user_data, GError **err)
{
	g_return_val_if_reached (FALSE);
}

static void
ianjuta_debugger_variable_base_init (IAnjutaDebuggerVariableIface* klass)
{
	static gboolean initialized = FALSE;

	klass->assign = ianjuta_debugger_variable_assign_default;
	klass->create = ianjuta_debugger_variable_create_default;
	klass->destroy = ianjuta_debugger_variable_destroy_default;
	klass->evaluate = ianjuta_debugger_variable_evaluate_default;
	klass->list_children = ianjuta_debugger_variable_list_children_default;
	klass->update = ianjuta_debugger_variable_update_default;
	
	if (!initialized) {

		initialized = TRUE;
	}
}

GType
ianjuta_debugger_variable_get_type (void)
{
	static GType type = 0;
	if (!type) {
		static const GTypeInfo info = {
			sizeof (IAnjutaDebuggerVariableIface),
			(GBaseInitFunc) ianjuta_debugger_variable_base_init,
			NULL, 
			NULL,
			NULL,
			NULL,
			0,
			0,
			NULL
		};
		type = g_type_register_static (G_TYPE_INTERFACE, "IAnjutaDebuggerVariable", &info, 0);
		g_type_interface_add_prerequisite (type, IANJUTA_TYPE_DEBUGGER);
	}
	return type;			
}
