/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 21:25:19 GMT 2018
 */

package uk.ac.sanger.artemis;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.AlignMatch;
import uk.ac.sanger.artemis.BlastM8ComparisonData;
import uk.ac.sanger.artemis.MSPcrunchComparisonData;
import uk.ac.sanger.artemis.MegaBlastComparisonData;
import uk.ac.sanger.artemis.SimpleComparisonData;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class SimpleComparisonData_ESTest extends SimpleComparisonData_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test0()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch((-2394), 0, 0, (-542), (-2394), 118);
      assertEquals((-2394), alignMatch0.getScore());
      assertEquals(118, alignMatch0.getPercentID());
      assertTrue(alignMatch0.isRevMatch());
      assertEquals(2394, alignMatch0.getLength());
  }

  @Test(timeout = 4000)
  public void test1()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = null;
      try {
        mSPcrunchComparisonData0 = new MSPcrunchComparisonData((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test2()  throws Throwable  {
      MegaBlastComparisonData megaBlastComparisonData0 = new MegaBlastComparisonData();
      // Undeclared exception!
      try { 
        megaBlastComparisonData0.getMinimumScore();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test3()  throws Throwable  {
      MSPcrunchComparisonData mSPcrunchComparisonData0 = new MSPcrunchComparisonData();
      // Undeclared exception!
      try { 
        mSPcrunchComparisonData0.getMaximumScore();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }

  @Test(timeout = 4000)
  public void test4()  throws Throwable  {
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch(0, 0, (-558), (-558), 2508, 15);
      assertEquals(0, alignMatch0.getLength());
      assertFalse(alignMatch0.isRevMatch());
      assertEquals(15, alignMatch0.getPercentID());
      assertEquals(2508, alignMatch0.getScore());
  }

  @Test(timeout = 4000)
  public void test5()  throws Throwable  {
      MegaBlastComparisonData megaBlastComparisonData0 = new MegaBlastComparisonData();
      AlignMatch[] alignMatchArray0 = new AlignMatch[2];
      AlignMatch alignMatch0 = SimpleComparisonData.makeAlignMatch((-542), 0, 118, (-542), (-542), (-542));
      alignMatchArray0[0] = alignMatch0;
      alignMatchArray0[1] = alignMatch0;
      megaBlastComparisonData0.setMatches(alignMatchArray0);
      assertEquals(2, alignMatchArray0.length);
  }

  @Test(timeout = 4000)
  public void test6()  throws Throwable  {
      BlastM8ComparisonData blastM8ComparisonData0 = new BlastM8ComparisonData();
      // Undeclared exception!
      try { 
        blastM8ComparisonData0.setMatches((AlignMatch[]) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.SimpleComparisonData", e);
      }
  }
}
