/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __command
#define __command

#include "help.h"

struct tokenizer;

struct command {

  std::string longname;
  std::string shortname;

  command (const std::string& ln, const std::string& sn) : longname (ln), shortname (sn) {}
  virtual bool operator() (tokenizer& tz) { return true; }
  virtual ~command () {}

};

struct cmdlist {

  std::vector<command*> cmds;
  int ncmds;

  std::string result; // holds last run command output

  static const int size = 2048;
  char buf [size]; // for console printing

  void add (command* cmd);

};

struct din;

struct set_var : command { // set var
  din* d;
  public:
    set_var (din* dd, const std::string& ln, const std::string& sn) : command (ln, sn), d(dd) {}
    bool operator() (tokenizer& tz);
    int set_scroll (std::string& varn, tokenizer& tz);
    int set_zoom_pan (int& rate, float& amount, std::string& varn, tokenizer& tz);
    ~set_var () {}
};

struct get_var : command { // get var
  din* d;
  public:
    get_var (din* dd, const std::string& ln, const std::string& sn) : command (ln, sn), d(dd) {}
    bool operator() (tokenizer& tz);
    ~get_var () {}
};

struct delay;
struct set_delay: command { // set delay time
  delay* left;
  delay* right;
  public:
    set_delay (delay* l, delay* r, const std::string& ln, const std::string& sn) : command (ln, sn), left(l), right(r) {}
    bool operator() (tokenizer& tz);
    ~set_delay () {}
};

struct get_delay: command { // get delay time
  delay* left;
  delay* right;
  public:
    get_delay (delay* l, delay* r, const std::string& ln, const std::string& sn) : command (ln, sn), left(l), right(r) {}
    bool operator() (tokenizer& tz);
    ~get_delay () {}
};

struct beat2value;

// bpm
//
struct bpm_com {
  static const int NUM = 4;
  static const char* str [NUM];
  static beat2value* bv [NUM];
  int getid (const std::string& name);
};

struct ls_bpm: command, bpm_com { // list bpmable components
  ls_bpm (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~ls_bpm () {}
};

struct set_bpm: command, bpm_com {
  set_bpm (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~set_bpm () {}
};

struct get_bpm: command, bpm_com {
  get_bpm (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~get_bpm () {}
};

struct set_style : command, bpm_com {
  set_style (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~set_style () {}
};

struct get_style : command, bpm_com {
  get_style (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~get_style () {}
};

struct set_beat : command, bpm_com {
  set_beat (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~set_beat () {}
};

struct get_beat : command, bpm_com {
  get_beat (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~get_beat () {}
};

struct add_scale: command {
  public:
    add_scale (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator () (tokenizer& tz);
    ~add_scale () {}
};

struct remove_scale : command {
  public:
    remove_scale (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator () (tokenizer& tz);
    ~remove_scale () {}
};

struct ls_scales: command {
  public:
    ls_scales (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator () (tokenizer& tz);
    ~ls_scales () {}
};

struct ls_notes: command {
  public:
    ls_notes (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator () (tokenizer& tz);
    ~ls_notes () {}
};

struct load_scale : command {
  din* d;
  int reentry;
  public:
    load_scale (din* dd, const std::string& ln, const std::string& sn) : command (ln, sn), d(dd) {}
    bool operator () (tokenizer& tz);
    ~load_scale () {}
};

struct key : command {
  din* d;
  public:
    key (din* dd, const std::string& ln, const std::string& sn) : command (ln, sn), d(dd) {}
    bool operator() (tokenizer& tz);
    ~key () {}
    void find_nearest_note (std::string& note, float& frequency, float& dist);
};

struct load_tuning: command {
  din* d;
  public:
    load_tuning (din* dd, const std::string& ln, const std::string& sn) : command (ln, sn), d(dd) {}
    bool operator() (tokenizer& tz);
    ~load_tuning () {}
};

struct notation : command {

  din* d;
  notation (din* dd, const std::string& ln, const std::string& sn) : command (ln, sn), d(dd) {}
  bool operator() (tokenizer& tz);
  ~notation () {}
};

struct note_distance: command {
  public:
    note_distance (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator() (tokenizer& tz);
    ~note_distance () {}
};

struct chord: command {
  public:
    chord (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator() (tokenizer& tz);
    ~chord () {}
};

struct set_font_size: command {

  public:
    set_font_size (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator() (tokenizer& tz);
    ~set_font_size () {}

};

struct get_font_size: command {

  public:
    get_font_size (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator() (tokenizer& tz);
    ~get_font_size () {}

};

struct set_kern: command {

  public:
    set_kern (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator() (tokenizer& tz);
    ~set_kern () {}

};

struct get_kern: command {

  public:
    get_kern (const std::string& ln, const std::string& sn) : command (ln, sn) {}
    bool operator() (tokenizer& tz);
    ~get_kern () {}

};

struct curve_name : command { // change picked curve name
  curve_name (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~curve_name () {}
};

struct multi_curve;

struct paste_gater: command {
  paste_gater (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~paste_gater () {}
};

struct curve_value : command { // change curve value (vertex, tangent)

  curve_value (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  ~curve_value () {}
  bool operator() (tokenizer& tz);

};

struct curve__library : command { // edit curve library attached to current curve editor
  curve__library (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~curve__library () {}
};

struct set_curve_editor : command {
  set_curve_editor (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~set_curve_editor () {}
};

struct set_scope : command {
  din* d;
  set_scope (const std::string& ln, const std::string& sn, din* dd) : command (ln, sn), d(dd) {}
  bool operator() (tokenizer& tz);
  ~set_scope () {}
};

struct get_scope : command {
  din* d;
  get_scope (const std::string& ln, const std::string& sn, din* dd) : command (ln, sn), d(dd) {}
  bool operator() (tokenizer& tz);
  ~get_scope () {}
};

struct echo : command {
  echo (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~echo () {}
};

struct set_text_color: command {
  set_text_color (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~set_text_color () {}
};

struct get_selection : command {
  get_selection (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~get_selection () {}
};

struct set_drone : command {
  din& d;
  set_drone (const std::string& ln, const std::string& sn, din& dd) : command (ln, sn), d(dd) {}
  bool operator() (tokenizer& tz);
  ~set_drone () {}
};

struct get_drone : command {
  din& d;
  get_drone (const std::string& ln, const std::string& sn, din& dd) : command (ln, sn), d(dd) {}
  bool operator() (tokenizer& tz);
  ~get_drone () {}
};

struct get_intervals : command {
  get_intervals (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~get_intervals () {}
};

struct num_octaves : command {
  din& d;
  num_octaves (const std::string& ln, const std::string& sn, din& dd) : command (ln, sn), d(dd) {}
  bool operator() (tokenizer& tz);
  ~num_octaves () {}
};

struct quit : command {
  quit (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~quit () {}
};

/*
struct template : command {
  template (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  ~template () {}
};*/

#endif
