/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import jalview.util.Format;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClustalFile
extends AlignFile {
    public ClustalFile() {
    }

    public ClustalFile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public ClustalFile(FileParse source) throws IOException {
        super(source);
    }

    public void initData() {
        super.initData();
    }

    public void parse() throws IOException {
        int i = 0;
        boolean flag = false;
        Vector<String> headers = new Vector<String>();
        Hashtable<String, StringBuffer> seqhash = new Hashtable<String, StringBuffer>();
        try {
            String line;
            while ((line = this.nextLine()) != null) {
                if (line.indexOf(" ") == 0) continue;
                StringTokenizer str = new StringTokenizer(line, " ");
                if (str.hasMoreTokens()) {
                    StringBuffer tempseq;
                    String id = str.nextToken();
                    if (id.equalsIgnoreCase("CLUSTAL")) {
                        flag = true;
                        continue;
                    }
                    if (!flag) continue;
                    if (seqhash.containsKey(id)) {
                        tempseq = (StringBuffer)seqhash.get(id);
                    } else {
                        tempseq = new StringBuffer();
                        seqhash.put(id, tempseq);
                    }
                    if (!headers.contains(id)) {
                        headers.addElement(id);
                    }
                    if (!str.hasMoreTokens()) continue;
                    tempseq.append(str.nextToken());
                    continue;
                }
                flag = true;
            }
        }
        catch (IOException e) {
            System.err.println("Exception parsing clustal file " + e);
            e.printStackTrace();
        }
        if (flag) {
            this.noSeqs = headers.size();
            for (i = 0; i < headers.size(); ++i) {
                if (seqhash.get(headers.elementAt(i)) != null) {
                    if (this.maxLength < seqhash.get(headers.elementAt(i)).toString().length()) {
                        this.maxLength = seqhash.get(headers.elementAt(i)).toString().length();
                    }
                    Sequence newSeq = this.parseId(headers.elementAt(i).toString());
                    newSeq.setSequence(seqhash.get(headers.elementAt(i).toString()).toString());
                    this.seqs.addElement(newSeq);
                    continue;
                }
                System.err.println("Clustal File Reader: Can't find sequence for " + headers.elementAt(i));
            }
        }
    }

    public String print() {
        return this.print(this.getSeqsAsArray());
    }

    public String print(SequenceI[] s) {
        int i;
        StringBuffer out = new StringBuffer("CLUSTAL\n\n");
        int max = 0;
        int maxid = 0;
        for (i = 0; i < s.length && s[i] != null; ++i) {
            String tmp = this.printId(s[i]);
            if (s[i].getSequence().length > max) {
                max = s[i].getSequence().length;
            }
            if (tmp.length() <= maxid) continue;
            maxid = tmp.length();
        }
        if (maxid < 15) {
            maxid = 15;
        }
        ++maxid;
        int len = 60;
        int nochunks = max / len + 1;
        for (i = 0; i < nochunks; ++i) {
            for (int j = 0; j < s.length && s[j] != null; ++j) {
                out.append(new Format("%-" + maxid + "s").form(this.printId(s[j]) + " "));
                int start = i * len;
                int end = start + len;
                if (end < s[j].getSequence().length && start < s[j].getSequence().length) {
                    out.append(s[j].getSequenceAsString(start, end));
                } else if (start < s[j].getSequence().length) {
                    out.append(s[j].getSequenceAsString().substring(start));
                }
                out.append("\n");
            }
            out.append("\n");
        }
        return out.toString();
    }
}

