/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.FieldTokenizer;
import com.sqlmagic.tinysql.tinySQLException;
import com.sqlmagic.tinysql.tinySQLGlobals;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class tinySQLCmd {
    static Vector tableList;
    static String dbVersion;
    static FileWriter spoolFileWriter;
    static String newLine;

    public static void main(String[] stringArray) throws IOException, SQLException {
        Connection connection;
        BufferedReader bufferedReader;
        boolean bl;
        String string;
        PreparedStatement preparedStatement;
        BufferedReader bufferedReader2;
        block72: {
            bufferedReader2 = null;
            preparedStatement = null;
            string = null;
            bl = false;
            bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            try {
                Class.forName("com.sqlmagic.tinysql.dbfFileDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("JDBC Driver could not be registered!!\n");
                if (!tinySQLGlobals.DEBUG) break block72;
                classNotFoundException.printStackTrace();
            }
        }
        String string2 = ".";
        if (stringArray.length > 0) {
            string2 = stringArray[0];
        }
        if ((connection = tinySQLCmd.dbConnect(string2)) == (Connection)null) {
            string2 = ".";
            connection = tinySQLCmd.dbConnect(string2);
        }
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String string3 = databaseMetaData.getDatabaseProductName();
        dbVersion = databaseMetaData.getDatabaseProductVersion();
        System.out.println("===================================================");
        System.out.println(string3 + " Command line interface version " + dbVersion + " released March 15, 2007");
        System.out.println("Type HELP to get information on available commands.");
        String string4 = "NULL";
        Statement statement = connection.createStatement();
        String string5 = null;
        if (stringArray.length > 1) {
            string5 = stringArray[1].trim();
        }
        while (!string4.toUpperCase().equals("EXIT")) {
            try {
                FieldTokenizer fieldTokenizer;
                if (bufferedReader2 != (BufferedReader)null) {
                    String string6;
                    StringBuffer stringBuffer = new StringBuffer();
                    string5 = null;
                    while ((string6 = bufferedReader2.readLine()) != null) {
                        if (string6.startsWith("--") | string6.startsWith("#")) continue;
                        stringBuffer.append(string6 + " ");
                        fieldTokenizer = new FieldTokenizer(stringBuffer.toString(), ';', true);
                        if (fieldTokenizer.countFields() <= 1) continue;
                        string5 = stringBuffer.toString();
                        break;
                    }
                    if (string5 == (String)null) {
                        bufferedReader2 = null;
                        continue;
                    }
                } else if (stringArray.length == 0) {
                    System.out.print("tinySQL>");
                    string5 = bufferedReader.readLine().trim();
                }
                if (string5 == (String)null || string5.toUpperCase().startsWith("EXIT") | string5.toUpperCase().startsWith("QUIT")) break;
                int n = 0;
                while (n < string5.length() - 1) {
                    int n2;
                    StringBuffer stringBuffer;
                    int n3;
                    ResultSetMetaData resultSetMetaData;
                    ResultSet resultSet;
                    int n4 = string5.indexOf(";", n);
                    if (n4 == -1) {
                        n4 = string5.length();
                    }
                    string4 = string5.substring(n, n4);
                    if (bl) {
                        System.out.println(string4);
                    }
                    n = n4 + 1;
                    if (string4.toUpperCase().startsWith("SELECT")) {
                        resultSet = statement.executeQuery(string4);
                        if (resultSet == (ResultSet)null) {
                            System.out.println("Null ResultSet returned from query");
                            continue;
                        }
                        resultSetMetaData = resultSet.getMetaData();
                        n3 = resultSetMetaData.getColumnCount();
                        stringBuffer = new StringBuffer(100);
                        int[] nArray = new int[n3];
                        int[] nArray2 = new int[n3];
                        int[] nArray3 = new int[n3];
                        int[] nArray4 = new int[n3];
                        String[] stringArray2 = new String[n3];
                        n2 = 0;
                        while (n2 < n3) {
                            stringArray2[n2] = resultSetMetaData.getColumnName(n2 + 1);
                            nArray[n2] = resultSetMetaData.getColumnDisplaySize(n2 + 1);
                            nArray4[n2] = resultSetMetaData.getColumnType(n2 + 1);
                            nArray2[n2] = resultSetMetaData.getScale(n2 + 1);
                            nArray3[n2] = resultSetMetaData.getPrecision(n2 + 1);
                            if (stringArray2[n2].length() > nArray[n2]) {
                                nArray[n2] = stringArray2[n2].length();
                            }
                            stringBuffer.append(tinySQLCmd.padString(stringArray2[n2], nArray[n2]) + " ");
                            ++n2;
                        }
                        if (tinySQLGlobals.DEBUG) {
                            System.out.println(stringBuffer.toString());
                        }
                        tinySQLCmd.displayResults(resultSet);
                        continue;
                    }
                    if (string4.toUpperCase().startsWith("CONNECT")) {
                        connection = tinySQLCmd.dbConnect(string4.substring(8, string4.length()));
                        continue;
                    }
                    if (string4.toUpperCase().startsWith("HELP")) {
                        tinySQLCmd.helpMsg(string4);
                        continue;
                    }
                    if (string4.toUpperCase().startsWith("DESCRIBE")) {
                        databaseMetaData = connection.getMetaData();
                        string = string4.toUpperCase().substring(9);
                        resultSet = databaseMetaData.getColumns(null, null, string, null);
                        System.out.println("\nColumns for table " + string + "\n" + "Name                            Type");
                        while (resultSet.next()) {
                            stringBuffer = new StringBuffer(100);
                            stringBuffer.append(tinySQLCmd.padString(resultSet.getString(4), 32));
                            String string7 = resultSet.getString(6);
                            int n5 = resultSet.getInt(5);
                            int n6 = resultSet.getInt(7);
                            int n7 = resultSet.getInt(9);
                            int n8 = resultSet.getInt(10);
                            if (string7.equals("CHAR")) {
                                string7 = string7 + "(" + Integer.toString(n6) + ")";
                            } else if (string7.equals("FLOAT")) {
                                string7 = string7 + "(" + Integer.toString(n8) + "," + Integer.toString(n7) + ")";
                            }
                            stringBuffer.append(tinySQLCmd.padString(string7, 20) + tinySQLCmd.padString(n5, 12));
                            System.out.println(stringBuffer.toString());
                        }
                        continue;
                    }
                    if (string4.toUpperCase().equals("SHOW TABLES")) {
                        n2 = 0;
                        while (n2 < tableList.size()) {
                            System.out.println((String)tableList.elementAt(n2));
                            ++n2;
                        }
                        continue;
                    }
                    if (string4.toUpperCase().equals("SHOW TYPES")) {
                        ResultSet resultSet2 = databaseMetaData.getTypeInfo();
                        int n9 = tinySQLCmd.displayResults(resultSet2);
                        continue;
                    }
                    if (string4.toUpperCase().startsWith("SET ")) {
                        fieldTokenizer = new FieldTokenizer(string4.toUpperCase(), ' ', false);
                        String[] stringArray3 = fieldTokenizer.getFields();
                        if (stringArray3[1].equals("ECHO")) {
                            if (stringArray3[2].equals("ON")) {
                                bl = true;
                                continue;
                            }
                            bl = false;
                            continue;
                        }
                        if (stringArray3[1].equals("DEBUG")) {
                            if (stringArray3[2].equals("ON")) {
                                tinySQLGlobals.DEBUG = true;
                                continue;
                            }
                            tinySQLGlobals.DEBUG = false;
                            continue;
                        }
                        if (stringArray3[1].equals("PARSER_DEBUG")) {
                            if (stringArray3[2].equals("ON")) {
                                tinySQLGlobals.PARSER_DEBUG = true;
                                continue;
                            }
                            tinySQLGlobals.PARSER_DEBUG = false;
                            continue;
                        }
                        if (stringArray3[1].equals("WHERE_DEBUG")) {
                            if (stringArray3[2].equals("ON")) {
                                tinySQLGlobals.WHERE_DEBUG = true;
                                continue;
                            }
                            tinySQLGlobals.WHERE_DEBUG = false;
                            continue;
                        }
                        if (!stringArray3[1].equals("EX_DEBUG")) continue;
                        if (stringArray3[2].equals("ON")) {
                            tinySQLGlobals.EX_DEBUG = true;
                            continue;
                        }
                        tinySQLGlobals.EX_DEBUG = false;
                        continue;
                    }
                    if (string4.toUpperCase().startsWith("SPOOL ")) {
                        fieldTokenizer = new FieldTokenizer(string4, ' ', false);
                        string2 = fieldTokenizer.getField(1);
                        if (string2.equals("OFF")) {
                            try {
                                spoolFileWriter.close();
                            }
                            catch (Exception exception) {
                                System.out.println("Unable to close spool file " + exception.getMessage() + newLine);
                            }
                            continue;
                        }
                        try {
                            spoolFileWriter = new FileWriter(string2);
                            if (spoolFileWriter == (FileWriter)null) continue;
                            System.out.println("Output spooled to " + string2);
                        }
                        catch (Exception exception) {
                            System.out.println("Unable to spool to file " + exception.getMessage() + newLine);
                        }
                        continue;
                    }
                    if (string4.toUpperCase().startsWith("START ")) {
                        fieldTokenizer = new FieldTokenizer(string4, ' ', false);
                        string2 = fieldTokenizer.getField(1);
                        if (!string2.toUpperCase().endsWith(".SQL")) {
                            string2 = string2 + ".SQL";
                        }
                        try {
                            bufferedReader2 = new BufferedReader(new FileReader(string2));
                            continue;
                        }
                        catch (Exception exception) {
                            bufferedReader2 = null;
                            throw new tinySQLException("No such file: " + string2);
                        }
                    }
                    if (string4.toUpperCase().startsWith("LOAD")) {
                        fieldTokenizer = new FieldTokenizer(string4, ' ', false);
                        string2 = fieldTokenizer.getField(1);
                        string = fieldTokenizer.getField(3);
                        resultSet = statement.executeQuery("SELECT * FROM " + string);
                        resultSetMetaData = resultSet.getMetaData();
                        n3 = resultSetMetaData.getColumnCount();
                        StringBuffer stringBuffer2 = new StringBuffer("INSERT INTO " + string);
                        StringBuffer stringBuffer3 = new StringBuffer(" VALUES");
                        n2 = 0;
                        while (n2 < n3) {
                            if (n2 == 0) {
                                stringBuffer2.append(" (");
                                stringBuffer3.append(" (");
                            } else {
                                stringBuffer2.append(",");
                                stringBuffer3.append(",");
                            }
                            stringBuffer2.append(resultSetMetaData.getColumnName(n2 + 1));
                            stringBuffer3.append("?");
                            ++n2;
                        }
                        stringBuffer2.append(")" + stringBuffer3.toString() + ")");
                        try {
                            String string8;
                            preparedStatement = connection.prepareStatement(stringBuffer2.toString());
                            BufferedReader bufferedReader3 = new BufferedReader(new FileReader(string2));
                            while ((string8 = bufferedReader3.readLine()) != null) {
                                if (string8.toUpperCase().equals("ENDOFDATA")) break;
                                int n10 = 0;
                                int n11 = 0;
                                fieldTokenizer = new FieldTokenizer(string8, '|', true);
                                while (fieldTokenizer.hasMoreFields()) {
                                    String string9 = fieldTokenizer.nextField();
                                    if (string9.equals("|")) {
                                        if (++n10 <= n11) continue;
                                        preparedStatement.setString(n11 + 1, null);
                                        ++n11;
                                        continue;
                                    }
                                    if (n10 >= n3) continue;
                                    preparedStatement.setString(n11 + 1, string9);
                                    ++n11;
                                }
                                preparedStatement.executeUpdate();
                            }
                            preparedStatement.close();
                        }
                        catch (Exception exception) {
                            System.out.println(exception.getMessage());
                        }
                        continue;
                    }
                    if (string4.toUpperCase().startsWith("SETSTRING") | string4.toUpperCase().startsWith("SETINT")) {
                        int n12 = string4.indexOf(" ");
                        int n13 = string4.lastIndexOf(" ");
                        if (!(n13 > n12 & n12 > 0)) continue;
                        int n14 = Integer.parseInt(string4.substring(n12 + 1, n13));
                        String string10 = string4.substring(n13 + 1);
                        if (tinySQLGlobals.DEBUG) {
                            System.out.println("Set parameter[" + n14 + "]=" + string10);
                        }
                        if (string4.toUpperCase().startsWith("SETINT")) {
                            int n15 = Integer.parseInt(string10);
                            preparedStatement.setInt(n14, n15);
                        } else {
                            preparedStatement.setString(n14, string10);
                        }
                        if (n14 != 2) continue;
                        preparedStatement.executeUpdate();
                        continue;
                    }
                    if (string4.indexOf("?") > -1) {
                        preparedStatement = connection.prepareStatement(string4);
                        continue;
                    }
                    try {
                        statement.executeUpdate(string4);
                        System.out.println("DONE\n");
                    }
                    catch (Exception exception) {
                        System.out.println(exception.getMessage());
                        if (!tinySQLGlobals.DEBUG) continue;
                        exception.printStackTrace();
                    }
                }
                if (stringArray.length <= 1) continue;
                string4 = "EXIT";
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
                if (tinySQLGlobals.DEBUG) {
                    sQLException.printStackTrace(System.out);
                }
                string5 = null;
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                string4 = "EXIT";
                break;
            }
        }
        try {
            if (spoolFileWriter != (FileWriter)null) {
                spoolFileWriter.close();
            }
        }
        catch (Exception exception) {
            System.out.println("Unable to close spool file " + exception.getMessage() + newLine);
        }
    }

    private static void helpMsg(String string) {
        String string2 = string.toUpperCase().trim();
        if (string2.equals("HELP")) {
            System.out.println("The following help topics are available:\n=============================================================\nHELP NEW - list of new features in tinySQL " + dbVersion + "\n" + "HELP COMMANDS - help for the non-SQL commands\n" + "HELP LIMITATIONS - limitations of tinySQL " + dbVersion + "\n" + "HELP ABOUT - short description of tinySQL.\n");
        } else if (string2.equals("HELP COMMANDS")) {
            System.out.println("The following non-SQL commands are supported:\n=============================================================\nSHOW TABLES - lists the tinySQL tables (DBF files) in the current directory\nSHOW TYPES - lists column types supported by tinySQL.\nDESCRIBE table_name - describes the columns in table table_name.\nCONNECT directory - connects to a different directory;\n   Examples:  CONNECT C:\\TEMP in Windows\n              CONNECT /home/mydir/temp in Linux/Unix\nSET DEBUG ON/OFF - turns general debugging on or off\nSET PARSER_DEBUG ON/OFF - turns parser debugging on or off\nSET WHERE_DEBUG ON/OFF - turns where clause debugging on or off\nSET EX_DEBUG ON/OFF - turns exception stack printing on or off\nSET ECHO ON/OFF - will echo input commands\nSTART <filename> - executes commands in the text file\nSPOOL <filename> - spools output of commands to the file\nEXIT - leave the tinySQL command line interface.\n");
        } else if (string2.equals("HELP LIMITATIONS")) {
            System.out.println("tinySQL " + dbVersion + " does NOT support the following:\n" + "=============================================================\n" + "Subqueries: eg SELECT COL1 from TABLE1 where COL2 in (SELECT ...\n" + "IN specification within a WHERE clause.\n" + "GROUP BY clause in SELECT statments.\n" + "AS in CREATE statements; eg CREATE TABLE TAB2 AS SELECT ...\n" + "UPDATE statements including JOINS.\n\n" + "If you run into others let us know by visiting\n" + "http://sourceforge.net/projects/tinysql\n");
        } else if (string2.equals("HELP NEW")) {
            System.out.println("New features in tinySQL releases.\n=============================================================\nVersion 2.26h released March 15, 2007\nCorrected problems with date comparisions, added support for \nthe TO_DATE function, corrected problems with DELETE.\nAdded support for IS NULL and IS NOT NULL, added ability\nto spool output to a file.\n---------------------------------------------------------------\nVersion 2.10 released October 22, 2006\nAdded support for long column names and fixed bugs in \nALTER TABLE commands.\n---------------------------------------------------------------\nVersion 2.02 released July 20, 2005\nFixed more bugs with the COUNT(*) and the like comparison.\n---------------------------------------------------------------\nVersion 2.01 released April 20, 2005\nFixed several bugs with the COUNT(*) and other summary functions\nFixed ORDER BY using columns that were not SELECTed.\nAdded support for DISTINCT keyword and TRIM function.\nAdded default sorting by selected column.\nSignificant reorganization of code to allow the use of functions\nin WHERE clauses (now stores tsColumn objects in tinySQLWhere).\n---------------------------------------------------------------\nVersion 2.0 released Dec. 20, 2004\nThe package name was changed to com.sqlmagic.tinysql.\nSupport for table aliases in JOINS: see example below\n  SELECT A.COL1,B.COL2 FROM TABLE1 A,TABLE2 B WHERE A.COL3=B.COL3\nCOUNT,MAX,MIN,SUM aggregate functions.\nCONCAT,UPPER,SUBSTR in-line functions for strings.\nSYSDATE - current date.\nSTART script_file.sql - executes SQL commands in file.\nSupport for selection of constants: see example below:\n  SELECT 'Full Name: ',first_name,last_name from person\nAll comparisions work properly: < > = != LIKE \n");
        } else if (string2.equals("HELP ABOUT")) {
            System.out.println("=============================================================\ntinySQL was originally written by Brian Jepson\nas part of the research he did while writing the book \nJava Database Programming (John Wiley, 1996).  The database was\nenhanced by Andreas Kraft, Thomas Morgner, Edson Alves Pereira,\nand Marcel Ruff between 1997 and 2002.\nThe current version " + dbVersion + " was developed by Davis Swan starting in 2004.\n\n" + "tinySQL is free software; you can redistribute it and/or\n" + "modify it under the terms of the GNU Lesser General Public\n" + "License as published by the Free Software Foundation; either\n" + "version 2.1 of the License, or (at your option) any later version.\n" + "This library is distributed in the hope that it will be useful,\n" + "but WITHOUT ANY WARRANTY; without even the implied warranty of\n" + "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n" + "Lesser General Public License for more details at\n" + "http://www.gnu.org/licenses/lgpl.html");
        } else {
            System.out.println("Unknown help command.\n");
        }
    }

    private static String padString(int n, int n2) {
        return tinySQLCmd.padString(Integer.toString(n), n2);
    }

    private static String padString(String string, int n) {
        String string2 = "                                        ";
        StringBuffer stringBuffer = string != (String)null ? new StringBuffer(string) : new StringBuffer(string2);
        while (stringBuffer.length() < n) {
            stringBuffer.append(string2);
        }
        return stringBuffer.toString().substring(0, n);
    }

    private static Connection dbConnect(String string) throws SQLException {
        Connection connection = null;
        File file = new File(string);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            System.out.println(string + " is not a valid directory.");
            return null;
        }
        System.out.println("Connecting to " + file.getAbsolutePath());
        connection = DriverManager.getConnection("jdbc:dbfFile:" + file, "", "");
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, null, null);
        tableList = new Vector();
        while (resultSet.next()) {
            String string2 = resultSet.getString("TABLE_NAME");
            tableList.addElement(string2);
        }
        if (tableList.size() == 0) {
            System.out.println("There are no tinySQL tables in this directory.");
        } else {
            System.out.println("There are " + tableList.size() + " tinySQL tables" + " in this directory.");
        }
        return connection;
    }

    static int displayResults(ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            System.err.println("ERROR in displayResult(): No data in ResultSet");
            return 0;
        }
        int n = 0;
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        int[] nArray = new int[n2];
        String string = "=============================================";
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (resultSet.next()) {
            String string2 = new String();
            int n3 = 0;
            while (n3 < n2) {
                String string3 = resultSet.getString(n3 + 1);
                if (bl) {
                    int n4;
                    nArray[n3] = resultSetMetaData.getColumnDisplaySize(n3 + 1);
                    if (tinySQLGlobals.DEBUG & resultSetMetaData.getColumnType(n3 + 1) == 91) {
                        Date date = resultSet.getDate(n3 + 1);
                        System.out.println("Value " + string3 + ", Date " + date.toString());
                    }
                    if ((n4 = resultSetMetaData.getColumnName(n3 + 1).length()) > nArray[n3]) {
                        nArray[n3] = n4;
                    }
                    stringBuffer.append(tinySQLCmd.padString(resultSetMetaData.getColumnName(n3 + 1), nArray[n3]));
                    stringBuffer.append(" ");
                    stringBuffer2.append(tinySQLCmd.padString(string + string, nArray[n3]));
                    stringBuffer2.append(" ");
                }
                string2 = string2 + tinySQLCmd.padString(string3, nArray[n3]);
                string2 = string2 + " ";
                ++n3;
            }
            try {
                if (bl) {
                    if (spoolFileWriter != (FileWriter)null) {
                        spoolFileWriter.write(stringBuffer.toString() + newLine);
                        spoolFileWriter.write(stringBuffer.toString() + newLine);
                    } else {
                        System.out.println(stringBuffer.toString());
                        System.out.println(stringBuffer2.toString());
                    }
                    bl = false;
                }
                if (spoolFileWriter != (FileWriter)null) {
                    spoolFileWriter.write(string2 + newLine);
                } else {
                    System.out.println(string2);
                }
                ++n;
            }
            catch (Exception exception) {
                System.out.println("Exception writing to spool file " + exception.getMessage());
            }
        }
        return n;
    }

    static {
        spoolFileWriter = null;
        newLine = System.getProperty("line.separator");
    }
}

