# -*- coding: utf-8 -*-
# Generated by Django 1.11.7 on 2017-12-05 16:24
from django.db import migrations, models
import django.db.models.deletion


OFFLINE, IDLE, RUNNING, OFFLINING, RETIRED, RESERVED = range(6)
OLD_HEALTH_UNKNOWN, OLD_HEALTH_PASS, OLD_HEALTH_FAIL, OLD_HEALTH_LOOPING = range(4)
STATE_IDLE, STATE_RESERVED, STATE_RUNNING = range(3)
(
    HEALTH_GOOD,
    HEALTH_UNKNOWN,
    HEALTH_LOOPING,
    HEALTH_BAD,
    HEALTH_MAINTENANCE,
    HEALTH_RETIRED,
) = range(6)


def revert_set_device_state_health(apps, schema_editor):
    Device = apps.get_model("lava_scheduler_app", "Device")

    def translate_state(new_state):
        if new_state == STATE_IDLE:
            return IDLE
        elif new_state == STATE_RESERVED:
            return RESERVED
        elif new_state == STATE_RUNNING:
            return RUNNING

    Device.objects.filter(health=HEALTH_MAINTENANCE).update(
        status=OFFLINE, health_status=OLD_HEALTH_FAIL
    )
    Device.objects.filter(health=HEALTH_RETIRED).update(
        status=RETIRED, health_status=OLD_HEALTH_FAIL
    )

    for device in Device.objects.filter(
        health__in=[HEALTH_GOOD, HEALTH_UNKNOWN, HEALTH_LOOPING, HEALTH_BAD]
    ):
        if device.health == HEALTH_GOOD:
            device.health_status = OLD_HEALTH_PASS
            device.status = translate_state(device.state)

        elif device.health == HEALTH_UNKNOWN:
            device.health_status = OLD_HEALTH_UNKNOWN
            device.status = translate_state(device.state)

        elif device.health == HEALTH_LOOPING:
            device.health_status = OLD_HEALTH_LOOPING
            device.status = translate_state(device.state)

        elif device.health == HEALTH_BAD:
            device.health_status = OLD_HEALTH_FAIL
            device.status = translate_state(device.state)

        device.save()


def set_device_state_health(apps, schema_editor):
    Device = apps.get_model("lava_scheduler_app", "Device")

    def translate_health_status(health_status):
        if health_status == OLD_HEALTH_UNKNOWN:
            return HEALTH_UNKNOWN
        elif health_status == OLD_HEALTH_PASS:
            return HEALTH_GOOD
        elif health_status == OLD_HEALTH_FAIL:
            return HEALTH_BAD
        elif health_status == OLD_HEALTH_LOOPING:
            return HEALTH_LOOPING

    Device.objects.filter(status=OFFLINING).update(
        state=STATE_RUNNING, health=HEALTH_MAINTENANCE
    )
    Device.objects.filter(status=RETIRED).update(
        state=STATE_IDLE, health=HEALTH_RETIRED
    )

    for device in Device.objects.filter(status__in=[OFFLINE, IDLE, RUNNING, RESERVED]):
        if device.status == OFFLINE:
            device.state = STATE_IDLE
            device.health = translate_health_status(device.health_status)

        elif device.status == IDLE:
            device.state = STATE_IDLE
            device.health = translate_health_status(device.health_status)

        elif device.status == RUNNING:
            device.state = STATE_RUNNING
            device.health = translate_health_status(device.health_status)

        elif device.status == RESERVED:
            device.state = STATE_RESERVED
            device.health = translate_health_status(device.health_status)

        device.save()


SUBMITTED, RUNNING, COMPLETE, INCOMPLETE, CANCELED, CANCELING = range(6)
(
    STATE_SUBMITTED,
    STATE_SCHEDULING,
    STATE_SCHEDULED,
    STATE_RUNNING,
    STATE_CANCELING,
    STATE_FINISHED,
) = range(6)
HEALTH_UNKNOWN, HEALTH_COMPLETE, HEALTH_INCOMPLETE, HEALTH_CANCELED = range(4)


def revert_set_testjob_state_health(apps, schema_editor):
    TestJob = apps.get_model("lava_scheduler_app", "TestJob")

    TestJob.objects.filter(state=STATE_SUBMITTED).update(status=SUBMITTED)
    TestJob.objects.filter(state=STATE_SCHEDULING).update(status=SUBMITTED)
    TestJob.objects.filter(state=STATE_SCHEDULED).update(status=SUBMITTED)
    TestJob.objects.filter(state=STATE_RUNNING).update(status=RUNNING)
    TestJob.objects.filter(state=STATE_CANCELING).update(status=CANCELING)
    TestJob.objects.filter(state=STATE_FINISHED, health=HEALTH_COMPLETE).update(
        status=COMPLETE
    )
    TestJob.objects.filter(state=STATE_FINISHED, health=HEALTH_INCOMPLETE).update(
        status=INCOMPLETE
    )
    TestJob.objects.filter(state=STATE_FINISHED, health=HEALTH_CANCELED).update(
        status=CANCELED
    )


def set_testjob_state_health(apps, schema_editor):
    TestJob = apps.get_model("lava_scheduler_app", "TestJob")

    TestJob.objects.filter(status=SUBMITTED).update(state=STATE_SUBMITTED)
    TestJob.objects.filter(status=RUNNING).update(state=STATE_RUNNING)
    TestJob.objects.filter(status=COMPLETE).update(
        state=STATE_FINISHED, health=HEALTH_COMPLETE
    )
    TestJob.objects.filter(status=INCOMPLETE).update(
        state=STATE_FINISHED, health=HEALTH_INCOMPLETE
    )
    TestJob.objects.filter(status=CANCELED).update(
        state=STATE_FINISHED, health=HEALTH_CANCELED
    )
    TestJob.objects.filter(status=CANCELING).update(state=STATE_CANCELING)


class Migration(migrations.Migration):

    dependencies = [("lava_scheduler_app", "0031_add_worker_state_and_health")]

    operations = [
        migrations.AddField(
            model_name="device",
            name="health",
            field=models.IntegerField(
                choices=[
                    (0, "Good"),
                    (1, "Unknown"),
                    (2, "Looping"),
                    (3, "Bad"),
                    (4, "Maintenance"),
                    (5, "Retired"),
                ],
                default=1,
            ),
        ),
        migrations.AddField(
            model_name="device",
            name="state",
            field=models.IntegerField(
                choices=[(0, "Idle"), (1, "Reserved"), (2, "Running")],
                default=0,
                editable=False,
            ),
        ),
        migrations.AddField(
            model_name="testjob",
            name="health",
            field=models.IntegerField(
                choices=[
                    (0, "Unknown"),
                    (1, "Complete"),
                    (2, "Incomplete"),
                    (3, "Canceled"),
                ],
                default=0,
            ),
        ),
        migrations.AddField(
            model_name="testjob",
            name="state",
            field=models.IntegerField(
                choices=[
                    (0, "Submitted"),
                    (1, "Scheduling"),
                    (2, "Scheduled"),
                    (3, "Running"),
                    (4, "Canceling"),
                    (5, "Finished"),
                ],
                default=0,
                editable=False,
            ),
        ),
        migrations.AlterField(
            model_name="testjob",
            name="actual_device",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="testjobs",
                to="lava_scheduler_app.Device",
            ),
        ),
        migrations.AlterIndexTogether(
            name="testjob",
            index_together=set([("health", "state", "requested_device_type")]),
        ),
        migrations.RunPython(set_device_state_health, revert_set_device_state_health),
        migrations.RunPython(set_testjob_state_health, revert_set_testjob_state_health),
    ]
