/* ----------------------------------------------------------------------
    This is the

    ██╗     ██╗ ██████╗  ██████╗  ██████╗ ██╗  ██╗████████╗███████╗
    ██║     ██║██╔════╝ ██╔════╝ ██╔════╝ ██║  ██║╚══██╔══╝██╔════╝
    ██║     ██║██║  ███╗██║  ███╗██║  ███╗███████║   ██║   ███████╗
    ██║     ██║██║   ██║██║   ██║██║   ██║██╔══██║   ██║   ╚════██║
    ███████╗██║╚██████╔╝╚██████╔╝╚██████╔╝██║  ██║   ██║   ███████║
    ╚══════╝╚═╝ ╚═════╝  ╚═════╝  ╚═════╝ ╚═╝  ╚═╝   ╚═╝   ╚══════╝®

    DEM simulation engine, released by
    DCS Computing Gmbh, Linz, Austria
    http://www.dcs-computing.com, office@dcs-computing.com

    LIGGGHTS® is part of CFDEM®project:
    http://www.liggghts.com | http://www.cfdem.com

    Core developer and main author:
    Christoph Kloss, christoph.kloss@dcs-computing.com

    LIGGGHTS® is open-source, distributed under the terms of the GNU Public
    License, version 2 or later. It is distributed in the hope that it will
    be useful, but WITHOUT ANY WARRANTY; without even the implied warranty
    of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. You should have
    received a copy of the GNU General Public License along with LIGGGHTS®.
    If not, see http://www.gnu.org/licenses . See also top-level README
    and LICENSE files.

    LIGGGHTS® and CFDEM® are registered trade marks of DCS Computing GmbH,
    the producer of the LIGGGHTS® software and the CFDEM®coupling software
    See http://www.cfdem.com/terms-trademark-policy for details.

-------------------------------------------------------------------------
    Contributing author and copyright for this file:
    (if not contributing author is listed, this file has been contributed
    by the core developer)

    Copyright 2012-     DCS Computing GmbH, Linz
    Copyright 2009-2012 JKU Linz
------------------------------------------------------------------------- */

#ifndef LMP_INPUT_MESH_TRI_H
#define LMP_INPUT_MESH_TRI_H

#include <stdio.h>
#include "input.h"
#include <fstream>

namespace LAMMPS_NS {

class InputMeshTri : protected Input
{
  public:

    InputMeshTri(class LAMMPS *lmp, int narg, char **arg);
    ~InputMeshTri();

    void meshtrifile(const char *filename,class TriMesh *mesh,bool verbose,
                     const int size_exclusion_list, int *exclusion_list,
                     class Region *region);

  private:

    bool verbose_;
    int i_exclusion_list_;
    int size_exclusion_list_;
    int *exclusion_list_;

    void meshtrifile_vtk(class TriMesh *mesh,class Region *region);
    void meshtrifile_stl(class TriMesh *mesh,class Region *region, const char * filename);
    void meshtrifile_stl_binary(class TriMesh *, class Region *region, const char * filename);
    inline void addTriangle(class TriMesh *mesh,
         double *a, double *b, double *c,int lineNumber);

};

}

#endif
