; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=armv7-none-eabi -float-abi=soft | FileCheck %s --check-prefixes=CHECK,CHECK-SOFT
; RUN: llc < %s -mtriple=armv7-none-eabihf -mattr=+vfp2 -float-abi=hard | FileCheck %s --check-prefixes=CHECK,CHECK-NOFP16
; RUN: llc < %s -mtriple=armv8-none-eabihf -mattr=+fp-armv8 -float-abi=hard | FileCheck %s --check-prefixes=CHECK,CHECK-FPv8
; RUN: llc < %s -mtriple=armv8-none-eabihf -mattr=+fp-armv8,+fullfp16 -float-abi=hard | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

define i32 @testmswh_builtin(half %x) {
; CHECK-SOFT-LABEL: testmswh_builtin:
; CHECK-SOFT:       @ %bb.0: @ %entry
; CHECK-SOFT-NEXT:    .save {r11, lr}
; CHECK-SOFT-NEXT:    push {r11, lr}
; CHECK-SOFT-NEXT:    bl __aeabi_h2f
; CHECK-SOFT-NEXT:    pop {r11, lr}
; CHECK-SOFT-NEXT:    b lroundf
;
; CHECK-NOFP16-LABEL: testmswh_builtin:
; CHECK-NOFP16:       @ %bb.0: @ %entry
; CHECK-NOFP16-NEXT:    .save {r11, lr}
; CHECK-NOFP16-NEXT:    push {r11, lr}
; CHECK-NOFP16-NEXT:    vmov r0, s0
; CHECK-NOFP16-NEXT:    bl __aeabi_h2f
; CHECK-NOFP16-NEXT:    vmov s0, r0
; CHECK-NOFP16-NEXT:    pop {r11, lr}
; CHECK-NOFP16-NEXT:    b lroundf
;
; CHECK-FPv8-LABEL: testmswh_builtin:
; CHECK-FPv8:       @ %bb.0: @ %entry
; CHECK-FPv8-NEXT:    vcvtb.f32.f16 s0, s0
; CHECK-FPv8-NEXT:    b lroundf
;
; CHECK-FP16-LABEL: testmswh_builtin:
; CHECK-FP16:       @ %bb.0: @ %entry
; CHECK-FP16-NEXT:    vcvta.s32.f16 s0, s0
; CHECK-FP16-NEXT:    vmov r0, s0
; CHECK-FP16-NEXT:    bx lr
entry:
  %0 = tail call i32 @llvm.lround.i32.f16(half %x)
  ret i32 %0
}

define i32 @testmsws_builtin(float %x) {
; CHECK-LABEL: testmsws_builtin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    b lroundf
entry:
  %0 = tail call i32 @llvm.lround.i32.f32(float %x)
  ret i32 %0
}

define i32 @testmswd_builtin(double %x) {
; CHECK-LABEL: testmswd_builtin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    b lround
entry:
  %0 = tail call i32 @llvm.lround.i32.f64(double %x)
  ret i32 %0
}

define i32 @testmswq_builtin(fp128 %x) {
; CHECK-LABEL: testmswq_builtin:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .save {r11, lr}
; CHECK-NEXT:    push {r11, lr}
; CHECK-NEXT:    bl lroundl
; CHECK-NEXT:    pop {r11, pc}
entry:
  %0 = tail call i32 @llvm.lround.i32.f128(fp128 %x)
  ret i32 %0
}

