/*
 * Decompiled with CFR 0.152.
 */
package org.tuckey.web;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.tuckey.web.MockRequestDispatcher;
import org.tuckey.web.MockSession;

public class MockRequest
implements HttpServletRequest {
    private String requestURI;
    private int serverPort = 80;
    private String queryString;
    private String method = "GET";
    private Hashtable headers = new Hashtable();
    private Hashtable attrs = new Hashtable();
    private Hashtable parameters = new Hashtable();
    private MockSession session = null;
    private String authType;
    private int contentLength;
    private String contentType;
    private String contextPath = "";
    private Cookie[] cookies;
    private int cookieCounter;
    private String pathInfo;
    private String pathTranslated;
    private String protocol;
    private String remoteAddr;
    private String remoteHost;
    private String remoteUser;
    private String requestedSessionId;
    private String requestUrl;
    private String serverName;
    private String servletPath;
    private String scheme;
    private int localPort = 0;
    private ArrayList roles = new ArrayList();
    String characterEncoding;

    public MockRequest() {
    }

    public MockRequest(String requestURI) {
        this.requestURI = this.contextPath + requestURI;
        this.servletPath = requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String s) {
        this.authType = s;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public long getDateHeader(String s) {
        return 0L;
    }

    public String getHeader(String s) {
        if (s == null) {
            return null;
        }
        return (String)this.headers.get(s);
    }

    public Enumeration getHeaders(String s) {
        return this.headers.elements();
    }

    public Enumeration getHeaderNames() {
        return this.headers.keys();
    }

    public int getIntHeader(String s) {
        return 0;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public boolean isUserInRole(String s) {
        return this.roles.contains(s);
    }

    public void addRole(String s) {
        this.roles.add(s);
    }

    public void removeRole(String s) {
        this.roles.remove(s);
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return this.requestedSessionId;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        if (this.requestUrl == null) {
            return null;
        }
        return new StringBuffer(this.requestUrl);
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean b) {
        if (b && this.session == null) {
            this.session = new MockSession();
        }
        return this.session;
    }

    public void setSessionNew(boolean b) {
        if (this.session == null) {
            this.session = new MockSession();
        }
        this.session.setNew(b);
    }

    public HttpSession getSession() {
        return this.session;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public Object getAttribute(String s) {
        return this.attrs.get(s);
    }

    public Enumeration getAttributeNames() {
        return null;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.characterEncoding = s;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String s) {
        return (String)this.parameters.get(s);
    }

    public Enumeration getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String s) {
        return new String[0];
    }

    public Map getParameterMap() {
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setAttribute(String s, Object o) {
        this.attrs.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attrs.remove(s);
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return new MockRequestDispatcher(s);
    }

    public String getRealPath(String s) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public void setServerPort(int i) {
        this.serverPort = i;
    }

    public void setQueryString(String s) {
        this.queryString = s;
    }

    public void setMethod(String s) {
        this.method = s;
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setContentLength(int i) {
        this.contentLength = i;
    }

    public void setContentType(String s) {
        this.contentType = s;
    }

    public void setContextPath(String s) {
        this.contextPath = s;
    }

    public void addCookie(Cookie c) {
        if (this.cookies == null) {
            this.cookies = new Cookie[100];
        }
        this.cookies[this.cookieCounter++] = c;
    }

    public void addParameter(String s, String s1) {
        this.parameters.put(s, s1);
    }

    public void setPathInfo(String s) {
        this.pathInfo = s;
    }

    public void setPathTranslated(String s) {
        this.pathTranslated = s;
    }

    public void setProtocol(String s) {
        this.protocol = s;
    }

    public void setRemoteAddr(String s) {
        this.remoteAddr = s;
    }

    public void setRemoteHost(String s) {
        this.remoteHost = s;
    }

    public void setRemoteUser(String s) {
        this.remoteUser = s;
    }

    public void setRequestedSessionId(String s) {
        this.requestedSessionId = s;
    }

    public void setRequestURL(String s) {
        this.requestUrl = s;
    }

    public void setServerName(String s) {
        this.serverName = s;
    }

    public void setScheme(String s) {
        this.scheme = s;
    }

    public void addHeader(String s, String s1) {
        this.headers.put(s, s1);
    }

    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }
}

