.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_encryption_method_supported.mdoc -- return if encryption method is supported
.\" Copyright (C) 2020 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_ENCRYPTION_METHOD_SUPPORTED" "3" "April 2, 2020" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_encryption_method_supported\fR
\- return if an encryption method is supported
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_encryption_method_supported\fR(\fIzip_int16_t\ method\fR, \fIint\ encrypt\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_encryption_method_supported\fR()
returns if the encryption method
\fImethod\fR
is supported for encryption (if
\fIencrypt\fR
is zero) or decryption (otherwise).
.SH "RETURN VALUES"
Returns 1 if the method is supported, 0 otherwise.
.SH "SEE ALSO"
libzip(3),
zip_compression_method_supported(3),
zip_file_set_encryption(3)
.SH "HISTORY"
\fBzip_encryption_method_supported\fR()
was added in libzip 1.7.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
