
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file LogoPlottingAttributes.h
    \\brief Definition of LogoPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "LogoPlottingAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

LogoPlottingAttributes::LogoPlottingAttributes():
	name_(ParameterManager::getString("page_id_line_logo_name"))
	
	
{
}


LogoPlottingAttributes::~LogoPlottingAttributes()
{

}


void LogoPlottingAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "page_id_line_logo_name", name_, params);
	
	
}

void LogoPlottingAttributes::copy(const LogoPlottingAttributes& other)
{
	name_ = other.name_;
	
}


bool LogoPlottingAttributes::accept(const string& node)
{

	if ( magCompare(node, "logo")  )
		return true;
	
	return false;
}

void LogoPlottingAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "logo")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void LogoPlottingAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " name = " <<  name_;
	
	out << "]" << "\n";
}

void LogoPlottingAttributes::toxml(ostream& out)  const
{
	out <<  "\"logo\"";
	out << ", \"page_id_line_logo_name\":";
	niceprint(out,name_);
	
}

static MagicsParameter<string> page_id_line_logo_name("page_id_line_logo_name", "ecmwf");
