
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file NetcdfVectorInterpretorAttributes.h
    \\brief Definition of NetcdfVectorInterpretor Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "NetcdfVectorInterpretorAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

NetcdfVectorInterpretorAttributes::NetcdfVectorInterpretorAttributes()
	
	
{
}


NetcdfVectorInterpretorAttributes::~NetcdfVectorInterpretorAttributes()
{

}


void NetcdfVectorInterpretorAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "netcdf";
	
	
	
}

void NetcdfVectorInterpretorAttributes::copy(const NetcdfVectorInterpretorAttributes& other)
{
	
}


bool NetcdfVectorInterpretorAttributes::accept(const string& node)
{

	if ( magCompare(node, "vector")  )
		return true;
	
	return false;
}

void NetcdfVectorInterpretorAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "vector")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void NetcdfVectorInterpretorAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	
	out << "]" << "\n";
}

void NetcdfVectorInterpretorAttributes::toxml(ostream& out)  const
{
	out <<  "\"vector\"";
	
}

