
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file HiLoTextAttributes.h
    \\brief Definition of HiLoText Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "HiLoTextWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


HiLoTextWrapper::HiLoTextWrapper(): hilotext_(new HiLoText())

{

	
	
	HiLoTechniqueWrapper::object(hilotext_);
	
	
} 
HiLoTextWrapper::HiLoTextWrapper(HiLoText* hilotext): hilotext_(hilotext)
{
	
	
	HiLoTechniqueWrapper::object(hilotext_);
	
} 

HiLoTextWrapper::~HiLoTextWrapper()
{
	
}

void HiLoTextWrapper::set(const MagRequest& request)
{
	
	
	
	HiLoTechniqueWrapper::set(request);
	

	if  (request.countValues("CONTOUR_HI_TEXT") ) {
		string hi_text_value = request("CONTOUR_HI_TEXT");
		hilotext_->hi_text_ = hi_text_value;
		}
	if  (request.countValues("CONTOUR_LO_TEXT") ) {
		string lo_text_value = request("CONTOUR_LO_TEXT");
		hilotext_->lo_text_ = lo_text_value;
		}
	if  (request.countValues("CONTOUR_HILO_BLANKING") ) {
		string blanking_value = request("CONTOUR_HILO_BLANKING");
		hilotext_->blanking_ = MagTranslator<string, bool>()(blanking_value);
		}
	
	
}

void HiLoTextWrapper::print(ostream& out)  const
{
	out << "HiLoTextWrapper[]";
}


    



