
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file OdaXYDecoderAttributes.h
    \\brief Definition of OdaXYDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "MagRequest.h" 
#include "OdaXYDecoderWrapper.h"
#include "MagicsParameter.h"
#include "Factory.h"
#include "MagTranslator.h"

using namespace magics;


OdaXYDecoderWrapper::OdaXYDecoderWrapper(): odaxydecoder_(new OdaXYDecoder())

{

	
	
	
} 
OdaXYDecoderWrapper::OdaXYDecoderWrapper(OdaXYDecoder* odaxydecoder): odaxydecoder_(odaxydecoder)
{
	
	
} 

OdaXYDecoderWrapper::~OdaXYDecoderWrapper()
{
	
}

void OdaXYDecoderWrapper::set(const MagRequest& request)
{
	
	

	if  (request.countValues("ODB_FILENAME") ) {
		string path_value = request("ODB_FILENAME");
		odaxydecoder_->path_ = path_value;
		}
	if  (request.countValues("ODB_X_VARIABLE") ) {
		string x_value = request("ODB_X_VARIABLE");
		odaxydecoder_->x_ = x_value;
		}
	if  (request.countValues("ODB_Y_VARIABLE") ) {
		string y_value = request("ODB_Y_VARIABLE");
		odaxydecoder_->y_ = y_value;
		}
	if  (request.countValues("ODB_VALUE_VARIABLE") ) {
		string value_value = request("ODB_VALUE_VARIABLE");
		odaxydecoder_->value_ = value_value;
		}
	if  (request.countValues("ODB_Y_COMPONENT_VARIABLE") ) {
		string y_component_value = request("ODB_Y_COMPONENT_VARIABLE");
		odaxydecoder_->y_component_ = y_component_value;
		}
	if  (request.countValues("ODB_X_COMPONENT_VARIABLE") ) {
		string x_component_value = request("ODB_X_COMPONENT_VARIABLE");
		odaxydecoder_->x_component_ = x_component_value;
		}
	if  (request.countValues("ODB_NB_ROWS") ) {
		int nb_rows_value = request("ODB_NB_ROWS");
		odaxydecoder_->nb_rows_ = nb_rows_value;
		}
	if  (request.countValues("ODB_USER_TITLE") ) {
		string title_value = request("ODB_USER_TITLE");
		odaxydecoder_->title_ = title_value;
		}
	
	
		string odb_binning_value = request.countValues("ODB_BINNING") ?  (string) request("ODB_BINNING") : "off";
	MagLog::debug() << " ODB_BINNING set to " << odb_binning_value << endl;
	BinningObjectWrapper* odb_binning_wrapper = 0;
	try
	{
		odb_binning_wrapper = SimpleFactory<BinningObjectWrapper>::create(odb_binning_value);
	}
	 catch (NoFactoryException) {
		MagLog::warning() << "[" << odb_binning_value << "] is not a valid value for odb_binning: reset to default -> [off]" << endl;
		odb_binning_wrapper = SimpleFactory<BinningObjectWrapper>::create("off");
	}
	odb_binning_wrapper->set(request);
	odaxydecoder_->odb_binning_ =  unique_ptr<BinningObject>(odb_binning_wrapper->object());
	delete odb_binning_wrapper;
	
}

void OdaXYDecoderWrapper::print(ostream& out)  const
{
	out << "OdaXYDecoderWrapper[]";
}


    



#include "BinningObjectWrapper.h"

static SimpleObjectMaker<BinningObjectWrapper> OdaXYDecoder_odb_binning_binning_Wrapper("binning");


#include "BinningObjectWrapper.h"

static SimpleObjectMaker<BinningObjectWrapper> OdaXYDecoder_odb_binning_on_Wrapper("on");


#include "NoBinningObjectWrapper.h"
static SimpleObjectMaker<NoBinningObject, BinningObject> OdaXYDecoder_odb_binning_nobinning ("nobinning");
static SimpleObjectMaker<NoBinningObjectWrapper, BinningObjectWrapper> OdaXYDecoder_odb_binning_nobinning_wrapper ("nobinning");


#include "NoBinningObjectWrapper.h"
static SimpleObjectMaker<NoBinningObject, BinningObject> OdaXYDecoder_odb_binning_off ("off");
static SimpleObjectMaker<NoBinningObjectWrapper, BinningObjectWrapper> OdaXYDecoder_odb_binning_off_wrapper ("off");



