
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileWindPlottingAttributes.h
    \brief Definition of WindPlotting Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef WindPlottingAttributes_H
#define WindPlottingAttributes_H

#include "magics.h"
#include "LevelSelection.h"
#include "ColourTechnique.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class WindPlottingAttributes 
{
public:
//  --  constructor
    WindPlottingAttributes();
    
//  --  destructor
    virtual ~WindPlottingAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const WindPlottingAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	bool legend_;
	bool legend_only_;
	string legend_text_;
	string advanced_method_;
	string colour_method_;
	double max_;
	double min_;
	int count_;
	int tolerance_;
	double reference_;
	double interval_;
	doublearray list_;
	string direction_;
	stringarray colours_;
	unique_ptr<LevelSelection> levels_;
	unique_ptr<ColourTechnique> colourMethod_;
	unique_ptr<Colour> maxColour_;
	unique_ptr<Colour> minColour_;
	ListPolicy colour_policy_;
	 

private:
	friend ostream& operator<<(ostream& s,const WindPlottingAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

