/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// Qt includes
#include <QMainWindow>


/////////////////////// Local includes
#include "../nongui/UserSpec.hpp"
#include "../nongui/ConfigSettings.hpp"


namespace MsXpS
{
namespace MassXpert
{


class ProgramWindow;


class AbstractMainTaskWindow : public QMainWindow
{
  Q_OBJECT
  public:
  AbstractMainTaskWindow(ProgramWindow *parent,
                         const QString &wndTypeName,
                         const QString &application_name,
                         const QString &description);

  ~AbstractMainTaskWindow();

  QString configSettingsFilePath();
  const UserSpec &userSpec();
  ConfigSettingsSPtr getConfigSettings() const;

  const ProgramWindow *mainWindow() const;

  protected:
  ProgramWindow *mp_parentWnd;

  QString m_wndTypeName;
  QString m_applicationName;
  QString m_windowDescription;

  virtual void readSettings();
  virtual void writeSettings();

  virtual bool initialize() = 0;

  protected slots:
  virtual void closeEvent(QCloseEvent *event);
};


} // namespace MassXpert
} // namespace MsXpS
