/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */

#pragma once


/////////////////////// Qt includes
#include <QSortFilterProxyModel>


/////////////////////// libpappsomspp includes
#include <pappsomspp/core/trace/trace.h>


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/Fragmenter.hpp>
#include <MsXpS/libXpertMassCore/FragmentationConfig.hpp>


/////////////////////// libXpertMassGui includes
#include <MsXpS/libXpertMassGui/MassPeakShaperConfigDlg.hpp>


/////////////////////// Local includes
#include "ui_FragmentationDlg.h"
#include "AbstractSeqEdWndDependentDlg.hpp"
#include "SequenceEditorWnd.hpp"
#include "FragmentOligomerTableViewModel.hpp"
#include "FragmentOligomerTableViewSortProxyModel.hpp"


namespace MsXpS
{
namespace MassXpert
{


class FragmentOligomerTableViewModel;
class FragmentOligomerTableViewSortProxyModel;

class FragmentationDlg : public AbstractSeqEdWndDependentDlg
{
  Q_OBJECT


  public:
  FragmentationDlg(SequenceEditorWnd *editor_wnd_p,
                   libXpertMassCore::PolymerQSPtr polymer_sp,
                   const libXpertMassCore::PolChemDefCstSPtr pol_chem_def_csp,
                   const QString &config_settings_file_path,
                   const QString &application_name,
                   const QString &description,
                   const libXpertMassCore::CalcOptions &calc_options,
                   const libXpertMassCore::Ionizer &ionizer);

  ~FragmentationDlg();

  bool initialize();

  bool populateSelectedOligomerData();
  void populateFragSpecList();

  void updateFragmentationDetails(const libXpertMassCore::CalcOptions &);
  void updateOligomerSequence(QString *);

  bool calculateTolerance(double);

  // The results-exporting functions. ////////////////////////////////
  void prepareResultsTxtString();
  bool exportResultsClipboard();
  bool exportResultsFile();
  bool selectResultsFile();
  //////////////////////////////////// The results-exporting functions.

  public slots:
  void fragment();
  void exportResults(int);
  void filterOptions(bool);
  void filterOptionsToggled();
  void filterPattern();
  void filterMonoMass();
  void filterAvgMass();
  void filterCharge();

  void massSpectrumSynthesisMenuActivated(int index);
  void traceColorPushButtonClicked();
  bool loadIsotopicDataFromFile();

  signals:

  void displayMassSpectrumSignal(const QString &title,
                                 const QByteArray &color_byte_array,
                                 pappso::TraceCstSPtr trace);

  private:
  Ui::FragmentationDlg m_ui;

  // The results-exporting strings. ////////////////////////////////
  QString *mpa_resultsString = nullptr;
  QString m_resultsFilePath;
  //////////////////////////////////// The results-exporting strings.

  libXpertMassCore::OligomerCollection m_oligomers;

  libXpertMassCore::IsotopicDataSPtr msp_isotopicData = nullptr;
  libXpertMassCore::MassPeakShaperConfig m_massPeakShaperConfig;

  pappso::Trace m_syntheticMassSpectrum;

  libXpertMassCore::CalcOptions m_calcOptions;
  libXpertMassCore::IndexRange m_fragmentIndexRange;
  const libXpertMassCore::Ionizer m_ionizer;

  // For the mass spectra that are synthesized and served.
  QByteArray m_colorByteArray;

  void writeSettings();
  void readSettings();

  FragmentOligomerTableViewModel *mpa_oligomerTableViewModel = nullptr;
  FragmentOligomerTableViewSortProxyModel *mpa_proxyModel    = nullptr;

  libXpertMassGui::MassPeakShaperConfigDlg *mp_massPeakShaperConfigDlg =
    nullptr;

  // For the filtering of the data in the treeview.
  QAction *filterAct      = nullptr;
  double m_tolerance      = 0;
  QWidget *mp_focusWidget = nullptr;

  void setupTableView();
  void configureMassPeakShaper();
  void synthesizeMassSpectra();
};


} // namespace MassXpert
} // namespace MsXpS
