/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2026 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - MassXpert, model polymer chemistries and simulate mass spectrometric data;
 * - MineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#pragma once

/////////////////////// stdlib includes


/////////////////////// Qt includes


/////////////////////// pappsomspp includes


/////////////////////// libXpertMass includes
#include <MsXpS/libXpertMassCore/PolChemDefSpec.hpp>


/////////////////////// libXpertMassGui includes


/////////////////////// Local includes
#include "ConfigSettings.hpp"

namespace MsXpS
{
namespace MassXpert
{


enum class ConfigPendingMode : uint8_t
{
  APPEND  = 0,
  PREPEND = 1
};


class PolChemDefCatParser
{
  public:
  PolChemDefCatParser();
  ~PolChemDefCatParser();

  void setFilePath(const QString &file_path);
  const QString &getFilePath() const;

  void setUserType(UserType user_type);
  UserType getUserType() const;

  void setConfigAddMode(ContainerItemAddMode add_mode);
  ContainerItemAddMode getConfigAddMode() const;

  int
  parseFiles(ConfigSettingsSPtr config_settings_sp,
             std::vector<libXpertMassCore::PolChemDefSpecSPtr> &pol_chem_def_specs,
             UserType user_type);

  int
  parseFile(ConfigSettingsSPtr config_settings_sp,
            const QString &file_path,
            std::vector<libXpertMassCore::PolChemDefSpecSPtr> &pol_chem_def_specs,
            UserType user_type);

  protected:
  UserType m_userType;
  ContainerItemAddMode m_configAddMode = ContainerItemAddMode::APPEND;
};


} // namespace MassXpert
} // namespace MsXpS
