/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import org.apache.ecs.ConcreteElement;
import org.apache.ecs.filter.CharacterFilter;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.util.RunData;

public abstract class Screen
extends Assembler {
    private static final CharacterFilter filter = Screen.htmlFilter();
    private static final CharacterFilter minFilter = Screen.htmlMinFilter();

    protected abstract ConcreteElement doBuild(RunData var1) throws Exception;

    protected ConcreteElement build(RunData data) throws Exception {
        return this.doBuild(data);
    }

    public String getLayout(RunData data) {
        return data.getLayout();
    }

    public void setLayout(RunData data, String layout) {
        data.setLayout(layout);
    }

    public static String prepareText(String s) {
        return filter.process(s);
    }

    public static String prepareTextMinimum(String s) {
        return minFilter.process(s);
    }

    private static CharacterFilter htmlFilter() {
        CharacterFilter filter = new CharacterFilter();
        filter.addAttribute("\"", (Object)"&#34;");
        filter.addAttribute("'", (Object)"&#8217;");
        filter.addAttribute("&", (Object)"&#38;");
        filter.addAttribute("<", (Object)"&#60;");
        filter.addAttribute(">", (Object)"&#62;");
        return filter;
    }

    private static CharacterFilter htmlMinFilter() {
        CharacterFilter filter = new CharacterFilter();
        filter.removeAttribute(">");
        filter.removeAttribute("\"");
        filter.removeAttribute("'");
        filter.removeAttribute("&");
        filter.addAttribute("<", (Object)"&#60;");
        return filter;
    }
}

