#pragma once
#ifndef BITS_OPERATION_UTIL_H
#define BITS_OPERATION_UTIL_H
#include "stdafx.h"
/*
 * Most bitwise operation are adopted from Sean Eron Anderson at Stanford
 */

/*
#ifdef BIT32
	#define WORD_SIZE unsigned int
	const unsigned int wordSize = 32;
#else */
#define WORD_SIZE unsigned long long
const unsigned int wordSize = 64;
// #endif

#ifdef __MSVC
#endif
#ifdef __GNUC__
#endif

// unsigned int reverse32bits(unsigned int word);
// unsigned long long reverse64bits(unsigned long long word);
// void printBinaryString(unsigned long long word, unsigned int length);

static const unsigned char BitReverseTable256[] = {
    0x00, 0x80, 0x40, 0xC0, 0x20, 0xA0, 0x60, 0xE0, 0x10, 0x90, 0x50, 0xD0, 0x30, 0xB0, 0x70, 0xF0,
    0x08, 0x88, 0x48, 0xC8, 0x28, 0xA8, 0x68, 0xE8, 0x18, 0x98, 0x58, 0xD8, 0x38, 0xB8, 0x78, 0xF8,
    0x04, 0x84, 0x44, 0xC4, 0x24, 0xA4, 0x64, 0xE4, 0x14, 0x94, 0x54, 0xD4, 0x34, 0xB4, 0x74, 0xF4,
    0x0C, 0x8C, 0x4C, 0xCC, 0x2C, 0xAC, 0x6C, 0xEC, 0x1C, 0x9C, 0x5C, 0xDC, 0x3C, 0xBC, 0x7C, 0xFC,
    0x02, 0x82, 0x42, 0xC2, 0x22, 0xA2, 0x62, 0xE2, 0x12, 0x92, 0x52, 0xD2, 0x32, 0xB2, 0x72, 0xF2,
    0x0A, 0x8A, 0x4A, 0xCA, 0x2A, 0xAA, 0x6A, 0xEA, 0x1A, 0x9A, 0x5A, 0xDA, 0x3A, 0xBA, 0x7A, 0xFA,
    0x06, 0x86, 0x46, 0xC6, 0x26, 0xA6, 0x66, 0xE6, 0x16, 0x96, 0x56, 0xD6, 0x36, 0xB6, 0x76, 0xF6,
    0x0E, 0x8E, 0x4E, 0xCE, 0x2E, 0xAE, 0x6E, 0xEE, 0x1E, 0x9E, 0x5E, 0xDE, 0x3E, 0xBE, 0x7E, 0xFE,
    0x01, 0x81, 0x41, 0xC1, 0x21, 0xA1, 0x61, 0xE1, 0x11, 0x91, 0x51, 0xD1, 0x31, 0xB1, 0x71, 0xF1,
    0x09, 0x89, 0x49, 0xC9, 0x29, 0xA9, 0x69, 0xE9, 0x19, 0x99, 0x59, 0xD9, 0x39, 0xB9, 0x79, 0xF9,
    0x05, 0x85, 0x45, 0xC5, 0x25, 0xA5, 0x65, 0xE5, 0x15, 0x95, 0x55, 0xD5, 0x35, 0xB5, 0x75, 0xF5,
    0x0D, 0x8D, 0x4D, 0xCD, 0x2D, 0xAD, 0x6D, 0xED, 0x1D, 0x9D, 0x5D, 0xDD, 0x3D, 0xBD, 0x7D, 0xFD,
    0x03, 0x83, 0x43, 0xC3, 0x23, 0xA3, 0x63, 0xE3, 0x13, 0x93, 0x53, 0xD3, 0x33, 0xB3, 0x73, 0xF3,
    0x0B, 0x8B, 0x4B, 0xCB, 0x2B, 0xAB, 0x6B, 0xEB, 0x1B, 0x9B, 0x5B, 0xDB, 0x3B, 0xBB, 0x7B, 0xFB,
    0x07, 0x87, 0x47, 0xC7, 0x27, 0xA7, 0x67, 0xE7, 0x17, 0x97, 0x57, 0xD7, 0x37, 0xB7, 0x77, 0xF7,
    0x0F, 0x8F, 0x4F, 0xCF, 0x2F, 0xAF, 0x6F, 0xEF, 0x1F, 0x9F, 0x5F, 0xDF, 0x3F, 0xBF, 0x7F, 0xFF
};

inline unsigned int reverse32bits(unsigned int word)
{
    unsigned int c;
    unsigned char * p = (unsigned char *) & word;
    unsigned char * q = (unsigned char *) & c;
    q[3] = BitReverseTable256[p[0]];
    q[2] = BitReverseTable256[p[1]];
    q[1] = BitReverseTable256[p[2]];
    q[0] = BitReverseTable256[p[3]];
    return c;
}

inline unsigned long long reverse64bits(unsigned long long word)
{
    //get the lower 32bits first
    unsigned long long returnValue =
        (unsigned long long) reverse32bits(0xffffffff & ((unsigned int) word));
    returnValue <<= 32; //shift to upper bits
    word >>= 32; //Shift upper bits to lower bits.
    returnValue += (unsigned long long) reverse32bits(0xffffffff & ((unsigned int) word));
    return (returnValue);
}

static const unsigned short MortonTable256[] = {
    0x0000, 0x0001, 0x0004, 0x0005, 0x0010, 0x0011, 0x0014, 0x0015,
    0x0040, 0x0041, 0x0044, 0x0045, 0x0050, 0x0051, 0x0054, 0x0055,
    0x0100, 0x0101, 0x0104, 0x0105, 0x0110, 0x0111, 0x0114, 0x0115,
    0x0140, 0x0141, 0x0144, 0x0145, 0x0150, 0x0151, 0x0154, 0x0155,
    0x0400, 0x0401, 0x0404, 0x0405, 0x0410, 0x0411, 0x0414, 0x0415,
    0x0440, 0x0441, 0x0444, 0x0445, 0x0450, 0x0451, 0x0454, 0x0455,
    0x0500, 0x0501, 0x0504, 0x0505, 0x0510, 0x0511, 0x0514, 0x0515,
    0x0540, 0x0541, 0x0544, 0x0545, 0x0550, 0x0551, 0x0554, 0x0555,
    0x1000, 0x1001, 0x1004, 0x1005, 0x1010, 0x1011, 0x1014, 0x1015,
    0x1040, 0x1041, 0x1044, 0x1045, 0x1050, 0x1051, 0x1054, 0x1055,
    0x1100, 0x1101, 0x1104, 0x1105, 0x1110, 0x1111, 0x1114, 0x1115,
    0x1140, 0x1141, 0x1144, 0x1145, 0x1150, 0x1151, 0x1154, 0x1155,
    0x1400, 0x1401, 0x1404, 0x1405, 0x1410, 0x1411, 0x1414, 0x1415,
    0x1440, 0x1441, 0x1444, 0x1445, 0x1450, 0x1451, 0x1454, 0x1455,
    0x1500, 0x1501, 0x1504, 0x1505, 0x1510, 0x1511, 0x1514, 0x1515,
    0x1540, 0x1541, 0x1544, 0x1545, 0x1550, 0x1551, 0x1554, 0x1555,
    0x4000, 0x4001, 0x4004, 0x4005, 0x4010, 0x4011, 0x4014, 0x4015,
    0x4040, 0x4041, 0x4044, 0x4045, 0x4050, 0x4051, 0x4054, 0x4055,
    0x4100, 0x4101, 0x4104, 0x4105, 0x4110, 0x4111, 0x4114, 0x4115,
    0x4140, 0x4141, 0x4144, 0x4145, 0x4150, 0x4151, 0x4154, 0x4155,
    0x4400, 0x4401, 0x4404, 0x4405, 0x4410, 0x4411, 0x4414, 0x4415,
    0x4440, 0x4441, 0x4444, 0x4445, 0x4450, 0x4451, 0x4454, 0x4455,
    0x4500, 0x4501, 0x4504, 0x4505, 0x4510, 0x4511, 0x4514, 0x4515,
    0x4540, 0x4541, 0x4544, 0x4545, 0x4550, 0x4551, 0x4554, 0x4555,
    0x5000, 0x5001, 0x5004, 0x5005, 0x5010, 0x5011, 0x5014, 0x5015,
    0x5040, 0x5041, 0x5044, 0x5045, 0x5050, 0x5051, 0x5054, 0x5055,
    0x5100, 0x5101, 0x5104, 0x5105, 0x5110, 0x5111, 0x5114, 0x5115,
    0x5140, 0x5141, 0x5144, 0x5145, 0x5150, 0x5151, 0x5154, 0x5155,
    0x5400, 0x5401, 0x5404, 0x5405, 0x5410, 0x5411, 0x5414, 0x5415,
    0x5440, 0x5441, 0x5444, 0x5445, 0x5450, 0x5451, 0x5454, 0x5455,
    0x5500, 0x5501, 0x5504, 0x5505, 0x5510, 0x5511, 0x5514, 0x5515,
    0x5540, 0x5541, 0x5544, 0x5545, 0x5550, 0x5551, 0x5554, 0x5555
};

// 11 bitwise operations
inline unsigned int InterleaveBits(unsigned short x, unsigned short y)
{
    unsigned int z = MortonTable256[y >> 8]   << 17 |
                     MortonTable256[x >> 8]   << 16 |
                     MortonTable256[y & 0xFF] <<  1 |
                     MortonTable256[x & 0xFF];
    return(z);
}

inline unsigned long long longlongShiftLeft(unsigned long long word, unsigned int shiftBits)
{
    const unsigned int BITS_PER_INT = 32;
    // Not all the compiler can support variable >> 32 dirrectly
    unsigned long long returnValue = word << (shiftBits % BITS_PER_INT);
    if (shiftBits >= BITS_PER_INT) {
        returnValue <<= 16;
        returnValue <<= 16;
    }
    return(returnValue);
}

inline unsigned long long longlongShiftRight(unsigned long long word, unsigned int shiftBits)
{
    const unsigned int BITS_PER_INT = 32;
    unsigned long long returnValue = word >> (shiftBits % BITS_PER_INT); // shift (word mod 32);
    if (shiftBits >= BITS_PER_INT) {
        returnValue >>= 16;
        returnValue >>= 16;
    }
    return(returnValue);
}

inline void clearLastBit(unsigned long long& bitsStr)
{
    bitsStr >>= 0x01;
    bitsStr <<= 0x01;
}

inline bool isKthBitSet(unsigned long long data, unsigned int k)
{
    unsigned long long flagMask = 0x01;
    if (k) {
        flagMask = longlongShiftLeft(flagMask, k - 1);
    }
    if (data & flagMask) {
        return(true);
    } else {
        return(false);
    }
}

inline void setKthBit(unsigned long long& bitsStr, unsigned int k, bool bit)
{
    unsigned long long flagMask = 0x01;
    if (k) {
        flagMask = longlongShiftLeft(flagMask, k - 1);
    }
    if (bit) {
        bitsStr |= flagMask;
    } else {
        bitsStr &= (!flagMask);
    }
}
#endif /* BITS_OPERATION_UTIL_H */


