/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalElement;
import jcckit.plot.AttributesHint;
import jcckit.plot.Hint;
import jcckit.plot.Symbol;
import jcckit.plot.SymbolFactory;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public abstract class AbstractSymbolFactory
implements SymbolFactory {
    protected final double _size;
    protected final GraphicAttributes _attributes;

    public AbstractSymbolFactory(ConfigParameters config) {
        this._size = config.getDouble("size", 0.01);
        this._attributes = (GraphicAttributes)Factory.createOrGet(config.getNode("attributes"), null);
    }

    @Override
    public Symbol createSymbol(GraphPoint point, Hint hintFromPreviousPoint, Hint hintFromPreviousCurve) {
        GraphicAttributes attributes = this._attributes;
        Hint hintForNextPoint = hintFromPreviousPoint;
        if (hintFromPreviousPoint instanceof AttributesHint) {
            attributes = ((AttributesHint)hintFromPreviousPoint).getAttributes();
            hintForNextPoint = ((AttributesHint)hintFromPreviousPoint).getNextHint();
        }
        return this.createSymbol(point, attributes, hintForNextPoint, hintFromPreviousCurve);
    }

    protected Symbol createSymbol(GraphPoint point, GraphicAttributes attributes, Hint hintForNextPoint, Hint hintFromPreviousCurve) {
        return new Symbol(this.createPlainSymbol(point, this._size, attributes), hintForNextPoint, hintFromPreviousCurve);
    }

    @Override
    public GraphicalElement createLegendSymbol(GraphPoint centerPosition, double size) {
        return this.createPlainSymbol(centerPosition, this._size, this._attributes);
    }

    protected abstract GraphicalElement createPlainSymbol(GraphPoint var1, double var2, GraphicAttributes var4);
}

