/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolPerson
extends USymbol {
    USymbolPerson() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.PERSON;
    }

    private void drawHeadAndBody(UGraphic ug, boolean shadowing, Dimension2D dimBody, double headSize) {
        UEllipse head = new UEllipse(headSize, headSize);
        URectangle body = new URectangle(dimBody).rounded(headSize);
        if (shadowing) {
            body.setDeltaShadow(3.0);
            head.setDeltaShadow(1.0);
        }
        double posx = (dimBody.getWidth() - headSize) / 2.0;
        ug.apply(UTranslate.dx(posx)).draw(head);
        ug.apply(UTranslate.dy(headSize)).draw(body);
    }

    private double headSize(Dimension2D dimBody) {
        double surface = dimBody.getWidth() * dimBody.getHeight();
        return Math.sqrt(surface) * 0.42;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dimFull = this.calculateDimension(ug.getStringBounder());
                Dimension2D dimBody = this.bodyDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dimFull);
                ug = symbolContext.apply(ug);
                double headSize = USymbolPerson.this.headSize(dimBody);
                USymbolPerson.this.drawHeadAndBody(ug, symbolContext.isShadowing(), dimBody, headSize);
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                USymbol.Margin margin = USymbolPerson.this.getMargin();
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1() + headSize)));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D body = this.bodyDimension(stringBounder);
                return Dimension2DDouble.delta(body, 0.0, USymbolPerson.this.headSize(body));
            }

            private Dimension2D bodyDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolPerson.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(TextBlock title, HorizontalAlignment labelAlignment, TextBlock stereotype, double width, double height, SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        throw new UnsupportedOperationException();
    }
}

