/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ActorHollow
extends AbstractTextBlock
implements TextBlock {
    private final double headDiam = 9.0;
    private final double bodyWidth = 25.0;
    private final double bodyHeight = 21.0;
    private final double neckHeight = 2.0;
    private final double armThickness = 5.0;
    private final double bodyThickness = 6.0;
    private final double legThickness = 6.0;
    private final SymbolContext symbolContext;

    public ActorHollow(SymbolContext symbolContext) {
        this.symbolContext = symbolContext;
    }

    @Override
    public void drawU(UGraphic ug) {
        UEllipse head = new UEllipse(9.0, 9.0);
        double centerX = this.getPreferredWidth() / 2.0;
        UPath path = new UPath();
        path.moveTo(-12.5, 0.0);
        path.lineTo(-12.5, 5.0);
        path.lineTo(-3.0, 5.0);
        path.lineTo(-3.0, 21.0 - (25.0 + 6.0 * Math.sqrt(2.0) - 6.0) / 2.0);
        path.lineTo(-12.5, 21.0 - 6.0 * Math.sqrt(2.0) / 2.0);
        path.lineTo(-(12.5 - 6.0 * Math.sqrt(2.0) / 2.0), 21.0);
        path.lineTo(0.0, 21.0 - (12.5 - 6.0 * Math.sqrt(2.0) / 2.0));
        path.lineTo(12.5 - 6.0 * Math.sqrt(2.0) / 2.0, 21.0);
        path.lineTo(12.5, 21.0 - 6.0 * Math.sqrt(2.0) / 2.0);
        path.lineTo(3.0, 21.0 - (25.0 + 6.0 * Math.sqrt(2.0) - 6.0) / 2.0);
        path.lineTo(3.0, 5.0);
        path.lineTo(12.5, 5.0);
        path.lineTo(12.5, 0.0);
        path.lineTo(-12.5, 0.0);
        path.closePath();
        if (this.symbolContext.getDeltaShadow() != 0.0) {
            head.setDeltaShadow(this.symbolContext.getDeltaShadow());
            path.setDeltaShadow(this.symbolContext.getDeltaShadow());
        }
        ug = this.symbolContext.apply(ug);
        ug.apply(new UTranslate(centerX - head.getWidth() / 2.0, this.thickness())).draw(head);
        ug.apply(new UTranslate(centerX, head.getHeight() + this.thickness() + 2.0)).draw(path);
    }

    private double thickness() {
        return this.symbolContext.getStroke().getThickness();
    }

    public double getPreferredWidth() {
        return 25.0 + this.thickness() * 2.0;
    }

    public double getPreferredHeight() {
        return 32.0 + this.thickness() * 2.0 + this.symbolContext.getDeltaShadow();
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(), this.getPreferredHeight());
    }
}

