# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.virtualenclaves import VirtualEnclavesMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-virtualenclaves
# USAGE
    python enclave_connection_create_or_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = VirtualEnclavesMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.enclave_connection.begin_create_or_update(
        resource_group_name="rgopenapi",
        enclave_connection_name="TestMyEnclaveConnection",
        resource={
            "location": "West US",
            "properties": {
                "communityResourceId": "/subscriptions/c64f6eca-bdc5-4bc2-88d6-f8f1dc23f86c/resourceGroups/testrg/providers/Microsoft.Mission/communities/TestMyCommunity",
                "destinationEndpointId": "/subscriptions/c64f6eca-bdc5-4bc2-88d6-f8f1dc23f86c/resourceGroups/TestMyRg/providers/Microsoft.Mission/virtualenclaves/TestMyEnclave/enclaveendpoints/TestMyEnclaveEndpoint",
                "sourceCidr": "10.0.0.0/24",
                "sourceResourceId": "/subscriptions/c64f6eca-bdc5-4bc2-88d6-f8f1dc23f86c/resourceGroups/TestMyRg/providers/microsoft.mission/virtualenclaves/TestMyEnclave",
            },
            "tags": {"sampletag": "samplevalue"},
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-05-01-preview/EnclaveConnection_CreateOrUpdate.json
if __name__ == "__main__":
    main()
