# PySNMP SMI module. Autogenerated from smidump -f python OSPF-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:24 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Gauge32, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Gauge32", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( RowStatus, TextualConvention, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "TextualConvention", "TimeStamp", "TruthValue")

# Types

class BigMetric(TextualConvention, Integer32):
    displayHint = "d-0"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,16777215)
    
class DesignatedRouterPriority(TextualConvention, Integer32):
    displayHint = "d-0"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,255)
    
class HelloRange(TextualConvention, Integer32):
    displayHint = "d-0"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,65535)
    
class Metric(TextualConvention, Integer32):
    displayHint = "d-0"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,65535)
    
class OspfAuthenticationType(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(0,1,2,)
    namedValues = NamedValues(("none", 0), ("simplePassword", 1), ("md5", 2), )
    
class PositiveInteger(TextualConvention, Integer32):
    displayHint = "d-0"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)
    
class Status(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(2,1,)
    namedValues = NamedValues(("enabled", 1), ("disabled", 2), )
    
class TOSType(TextualConvention, Integer32):
    displayHint = "d-0"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,30)
    
class UpToMaxAge(TextualConvention, Integer32):
    displayHint = "d-0"
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,3600)
    
class AreaID(IpAddress):
    pass

class RouterID(IpAddress):
    pass


# Objects

ospf = ModuleIdentity((1, 3, 6, 1, 2, 1, 14)).setRevisions(("2006-11-10 00:00","1995-01-20 12:25",))
if mibBuilder.loadTexts: ospf.setOrganization("IETF OSPF Working Group")
if mibBuilder.loadTexts: ospf.setContactInfo("WG E-Mail: ospf@ietf.org\n\nWG Chairs: acee@cisco.com\n           rohit@gmail.com\n\nEditors:   Dan Joyal\n           Nortel\n           600 Technology Park Drive\n           Billerica, MA  01821\n           djoyal@nortel.com\n\n           Piotr Galecki\n           Airvana\n           19 Alpha Road\n           Chelmsford, MA 01824\n           pgalecki@airvana.com\n\n           Spencer Giacalone\n           CSFB\n           Eleven Madison Ave\n           New York, NY 10010-3629\n           spencer.giacalone@gmail.com")
if mibBuilder.loadTexts: ospf.setDescription("The MIB module to describe the OSPF Version 2\nProtocol.  Note that some objects in this MIB\nmodule may pose a significant security risk.\nRefer to the Security Considerations section\nin RFC 4750 for more information.\n\n\n\nCopyright (C) The IETF Trust (2006).\nThis version of this MIB module is part of\nRFC 4750;  see the RFC itself for full legal\nnotices.")
ospfGeneralGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 1))
ospfRouterId = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 1), RouterID()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRouterId.setDescription("A 32-bit integer uniquely identifying the\nrouter in the Autonomous System.\nBy convention, to ensure uniqueness, this\nshould default to the value of one of the\nrouter's IP interface addresses.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile storage.")
ospfAdminStat = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 2), Status()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfAdminStat.setDescription("The administrative status of OSPF in the\nrouter.  The value 'enabled' denotes that the\nOSPF Process is active on at least one interface;\n'disabled' disables it on all interfaces.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile storage.")
ospfVersionNumber = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,)).subtype(namedValues=NamedValues(("version2", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVersionNumber.setDescription("The current version number of the OSPF protocol is 2.")
ospfAreaBdrRtrStatus = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 4), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaBdrRtrStatus.setDescription("A flag to note whether this router is an Area\nBorder Router.")
ospfASBdrRtrStatus = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 5), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfASBdrRtrStatus.setDescription("A flag to note whether this router is configured as\nan Autonomous System Border Router.\n\nThis object is persistent and when written the\nentity SHOULD save the change to non-volatile storage.")
ospfExternLsaCount = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExternLsaCount.setDescription("The number of external (LS type-5) link state\nadvertisements in the link state database.")
ospfExternLsaCksumSum = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExternLsaCksumSum.setDescription("The 32-bit sum of the LS checksums of\nthe external link state advertisements\ncontained in the link state database.  This sum\ncan be used to determine if there has been a\nchange in a router's link state database and\nto compare the link state database of two\nrouters.  The value should be treated as unsigned\nwhen comparing two sums of checksums.")
ospfTOSSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 8), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfTOSSupport.setDescription("The router's support for type-of-service routing.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfOriginateNewLsas = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfOriginateNewLsas.setDescription("The number of new link state advertisements\nthat have been originated.  This number is\nincremented each time the router originates a new\nLSA.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nospfDiscontinuityTime.")
ospfRxNewLsas = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfRxNewLsas.setDescription("The number of link state advertisements received\nthat are determined to be new instantiations.\nThis number does not include newer instantiations\nof self-originated link state advertisements.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management system,\nand at other times as indicated by the value of\nospfDiscontinuityTime.")
ospfExtLsdbLimit = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 11), Integer32().subtype(subtypeSpec=ValueRangeConstraint(-1, 2147483647)).clone(-1)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfExtLsdbLimit.setDescription("The maximum number of non-default\nAS-external LSAs entries that can be stored in the\nlink state database.  If the value is -1, then\nthere is no limit.\n\nWhen the number of non-default AS-external LSAs\nin a router's link state database reaches\nospfExtLsdbLimit, the router enters\noverflow state.  The router never holds more than\nospfExtLsdbLimit non-default AS-external LSAs\nin its database.  OspfExtLsdbLimit MUST be set\nidentically in all routers attached to the OSPF\nbackbone and/or any regular OSPF area (i.e.,\nOSPF stub areas and NSSAs are excluded).\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfMulticastExtensions = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 12), Integer32().clone(0)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfMulticastExtensions.setDescription("A bit mask indicating whether the router is\nforwarding IP multicast (Class D) datagrams\nbased on the algorithms defined in the\nmulticast extensions to OSPF.\n\nBit 0, if set, indicates that the router can\n\n\n\nforward IP multicast datagrams in the router's\ndirectly attached areas (called intra-area\nmulticast routing).\n\nBit 1, if set, indicates that the router can\nforward IP multicast datagrams between OSPF\nareas (called inter-area multicast routing).\n\nBit 2, if set, indicates that the router can\nforward IP multicast datagrams between\nAutonomous Systems (called inter-AS multicast\nrouting).\n\nOnly certain combinations of bit settings are\nallowed, namely: 0 (no multicast forwarding is\nenabled), 1 (intra-area multicasting only), 3\n(intra-area and inter-area multicasting), 5\n(intra-area and inter-AS multicasting), and 7\n(multicasting everywhere).  By default, no\nmulticast forwarding is enabled.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfExitOverflowInterval = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 13), PositiveInteger().clone('0')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfExitOverflowInterval.setDescription("The number of seconds that, after entering\nOverflowState, a router will attempt to leave\nOverflowState.  This allows the router to again\noriginate non-default AS-external LSAs.  When\nset to 0, the router will not leave\noverflow state until restarted.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfDemandExtensions = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 14), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfDemandExtensions.setDescription("The router's support for demand routing.\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfRFC1583Compatibility = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 15), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRFC1583Compatibility.setDescription("Indicates metrics used to choose among multiple\nAS-external LSAs.  When RFC1583Compatibility is set to\nenabled, only cost will be used when choosing among\nmultiple AS-external LSAs advertising the same\ndestination.  When RFC1583Compatibility is set to\ndisabled, preference will be driven first by type of\npath using cost only to break ties.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfOpaqueLsaSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 16), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfOpaqueLsaSupport.setDescription("The router's support for Opaque LSA types.")
ospfReferenceBandwidth = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 17), Unsigned32()).setMaxAccess("readwrite").setUnits("kilobits per second")
if mibBuilder.loadTexts: ospfReferenceBandwidth.setDescription("Reference bandwidth in kilobits/second for\n\n\n\ncalculating default interface metrics.  The\ndefault value is 100,000 KBPS (100 MBPS).\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfRestartSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 18), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("none", 1), ("plannedOnly", 2), ("plannedAndUnplanned", 3), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRestartSupport.setDescription("The router's support for OSPF graceful restart.\nOptions include: no restart support, only planned\nrestarts, or both planned and unplanned restarts.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfRestartInterval = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 19), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 1800))).setMaxAccess("readwrite").setUnits("seconds")
if mibBuilder.loadTexts: ospfRestartInterval.setDescription("Configured OSPF graceful restart timeout interval.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfRestartStrictLsaChecking = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 20), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfRestartStrictLsaChecking.setDescription("Indicates if strict LSA checking is enabled for\ngraceful restart.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\n\n\n\nstorage.")
ospfRestartStatus = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 21), Integer().subtype(subtypeSpec=SingleValueConstraint(2,3,1,)).subtype(namedValues=NamedValues(("notRestarting", 1), ("plannedRestart", 2), ("unplannedRestart", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfRestartStatus.setDescription("Current status of OSPF graceful restart.")
ospfRestartAge = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 22), Unsigned32()).setMaxAccess("readonly").setUnits("seconds")
if mibBuilder.loadTexts: ospfRestartAge.setDescription("Remaining time in current OSPF graceful restart\ninterval.")
ospfRestartExitReason = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 23), Integer().subtype(subtypeSpec=SingleValueConstraint(1,5,3,4,2,)).subtype(namedValues=NamedValues(("none", 1), ("inProgress", 2), ("completed", 3), ("timedOut", 4), ("topologyChanged", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfRestartExitReason.setDescription("Describes the outcome of the last attempt at a\ngraceful restart.  If the value is 'none', no restart\nhas yet been attempted.  If the value is 'inProgress',\na restart attempt is currently underway.")
ospfAsLsaCount = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 24), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsaCount.setDescription("The number of AS-scope link state\nadvertisements in the AS-scope link state database.")
ospfAsLsaCksumSum = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 25), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsaCksumSum.setDescription("The 32-bit unsigned sum of the LS checksums of\nthe AS link state advertisements contained in the AS-scope\nlink state database.  This sum can be used to determine\nif there has been a change in a router's AS-scope link\nstate database, and to compare the AS-scope link state\ndatabase of two routers.")
ospfStubRouterSupport = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 26), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfStubRouterSupport.setDescription("The router's support for stub router functionality.")
ospfStubRouterAdvertisement = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 27), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("doNotAdvertise", 1), ("advertise", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ospfStubRouterAdvertisement.setDescription("This object controls the advertisement of\nstub router LSAs by the router.  The value\ndoNotAdvertise will result in the advertisement\nof a standard router LSA and is the default value.\n\nThis object is persistent and when written\nthe entity SHOULD save the change to non-volatile\nstorage.")
ospfDiscontinuityTime = MibScalar((1, 3, 6, 1, 2, 1, 14, 1, 28), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion\nat which any one of this MIB's counters suffered\na discontinuity.\n\nIf no such discontinuities have occurred since the last\nre-initialization of the local management subsystem,\nthen this object contains a zero value.")
ospfAreaTable = MibTable((1, 3, 6, 1, 2, 1, 14, 2))
if mibBuilder.loadTexts: ospfAreaTable.setDescription("Information describing the configured parameters and\ncumulative statistics of the router's attached areas.\nThe interfaces and virtual links are configured\nas part of these areas.  Area 0.0.0.0, by definition,\nis the backbone area.")
ospfAreaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 2, 1)).setIndexNames((0, "OSPF-MIB", "ospfAreaId"))
if mibBuilder.loadTexts: ospfAreaEntry.setDescription("Information describing the configured parameters and\ncumulative statistics of one of the router's attached areas.\nThe interfaces and virtual links are configured as part of\nthese areas.  Area 0.0.0.0, by definition, is the backbone\narea.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\nstorage.")
ospfAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaId.setDescription("A 32-bit integer uniquely identifying an area.\nArea ID 0.0.0.0 is used for the OSPF backbone.")
ospfAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 2), OspfAuthenticationType().clone('none')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAuthType.setDescription("The authentication type specified for an area.")
ospfImportAsExtern = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,)).subtype(namedValues=NamedValues(("importExternal", 1), ("importNoExternal", 2), ("importNssa", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfImportAsExtern.setDescription("Indicates if an area is a stub area, NSSA, or standard\narea.  Type-5 AS-external LSAs and type-11 Opaque LSAs are\nnot imported into stub areas or NSSAs.  NSSAs import\nAS-external data as type-7 LSAs")
ospfSpfRuns = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfSpfRuns.setDescription("The number of times that the intra-area route\ntable has been calculated using this area's\nlink state database.  This is typically done\nusing Dijkstra's algorithm.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at other\ntimes as indicated by the value of ospfDiscontinuityTime.")
ospfAreaBdrRtrCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaBdrRtrCount.setDescription("The total number of Area Border Routers reachable\nwithin this area.  This is initially zero and is\ncalculated in each Shortest Path First (SPF) pass.")
ospfAsBdrRtrCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsBdrRtrCount.setDescription("The total number of Autonomous System Border\nRouters reachable within this area.  This is\ninitially zero and is calculated in each SPF\npass.")
ospfAreaLsaCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaLsaCount.setDescription("The total number of link state advertisements\nin this area's link state database, excluding\nAS-external LSAs.")
ospfAreaLsaCksumSum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 8), Integer32().clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaLsaCksumSum.setDescription("The 32-bit sum of the link state\nadvertisements' LS checksums contained in this\narea's link state database.  This sum excludes\nexternal (LS type-5) link state advertisements.\nThe sum can be used to determine if there has\nbeen a change in a router's link state\ndatabase, and to compare the link state database of\ntwo routers.  The value should be treated as unsigned\nwhen comparing two sums of checksums.")
ospfAreaSummary = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("noAreaSummary", 1), ("sendAreaSummary", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaSummary.setDescription("The variable ospfAreaSummary controls the\nimport of summary LSAs into stub and NSSA areas.\nIt has no effect on other areas.\n\nIf it is noAreaSummary, the router will not\noriginate summary LSAs into the stub or NSSA area.\nIt will rely entirely on its default route.\n\nIf it is sendAreaSummary, the router will both\nsummarize and propagate summary LSAs.")
ospfAreaStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfAreaNssaTranslatorRole = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("always", 1), ("candidate", 2), )).clone(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaNssaTranslatorRole.setDescription("Indicates an NSSA border router's ability to\nperform NSSA translation of type-7 LSAs into\ntype-5 LSAs.")
ospfAreaNssaTranslatorState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("elected", 2), ("disabled", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaNssaTranslatorState.setDescription("Indicates if and how an NSSA border router is\nperforming NSSA translation of type-7 LSAs into type-5\n\n\n\nLSAs.  When this object is set to enabled, the NSSA Border\nrouter's OspfAreaNssaExtTranslatorRole has been set to\nalways.  When this object is set to elected, a candidate\nNSSA Border router is Translating type-7 LSAs into type-5.\nWhen this object is set to disabled, a candidate NSSA\nborder router is NOT translating type-7 LSAs into type-5.")
ospfAreaNssaTranslatorStabilityInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 13), PositiveInteger().clone('40')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaNssaTranslatorStabilityInterval.setDescription("The number of seconds after an elected translator\ndetermines its services are no longer required, that\nit should continue to perform its translation duties.")
ospfAreaNssaTranslatorEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaNssaTranslatorEvents.setDescription("Indicates the number of translator state changes\nthat have occurred since the last boot-up.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at other\ntimes as indicated by the value of ospfDiscontinuityTime.")
ospfStubAreaTable = MibTable((1, 3, 6, 1, 2, 1, 14, 3))
if mibBuilder.loadTexts: ospfStubAreaTable.setDescription("The set of metrics that will be advertised\nby a default Area Border Router into a stub area.")
ospfStubAreaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 3, 1)).setIndexNames((0, "OSPF-MIB", "ospfStubAreaId"), (0, "OSPF-MIB", "ospfStubTOS"))
if mibBuilder.loadTexts: ospfStubAreaEntry.setDescription("The metric for a given Type of Service that\nwill be advertised by a default Area Border\nRouter into a stub area.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\nstorage.")
ospfStubAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfStubAreaId.setDescription("The 32-bit identifier for the stub area.  On\ncreation, this can be derived from the\ninstance.")
ospfStubTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 2), TOSType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfStubTOS.setDescription("The Type of Service associated with the\nmetric.  On creation, this can be derived from\n\n\n\nthe instance.")
ospfStubMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 3), BigMetric()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfStubMetric.setDescription("The metric value applied at the indicated Type\nof Service.  By default, this equals the least\nmetric at the Type of Service among the\ninterfaces to other areas.")
ospfStubStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfStubStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfStubMetricType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 3, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,)).subtype(namedValues=NamedValues(("ospfMetric", 1), ("comparableCost", 2), ("nonComparable", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfStubMetricType.setDescription("This variable displays the type of metric\nadvertised as a default route.")
ospfLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 4))
if mibBuilder.loadTexts: ospfLsdbTable.setDescription("The OSPF Process's link state database (LSDB).\nThe LSDB contains the link state advertisements\nfrom throughout the areas that the device is attached to.")
ospfLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 4, 1)).setIndexNames((0, "OSPF-MIB", "ospfLsdbAreaId"), (0, "OSPF-MIB", "ospfLsdbType"), (0, "OSPF-MIB", "ospfLsdbLsid"), (0, "OSPF-MIB", "ospfLsdbRouterId"))
if mibBuilder.loadTexts: ospfLsdbEntry.setDescription("A single link state advertisement.")
ospfLsdbAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAreaId.setDescription("The 32-bit identifier of the area from which\nthe LSA was received.")
ospfLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,4,10,5,2,7,6,)).subtype(namedValues=NamedValues(("routerLink", 1), ("areaOpaqueLink", 10), ("networkLink", 2), ("summaryLink", 3), ("asSummaryLink", 4), ("asExternalLink", 5), ("multicastLink", 6), ("nssaExternalLink", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbType.setDescription("The type of the link state advertisement.\nEach link state type has a separate advertisement\nformat.\n\nNote: External link state advertisements are permitted\nfor backward compatibility, but should be displayed\nin the ospfAsLsdbTable rather than here.")
ospfLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbLsid.setDescription("The Link State ID is an LS Type Specific field\ncontaining either a Router ID or an IP address;\nit identifies the piece of the routing domain\nthat is being described by the advertisement.")
ospfLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 4), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbRouterId.setDescription("The 32-bit number that uniquely identifies the\noriginating router in the Autonomous System.")
ospfLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbSequence.setDescription("The sequence number field is a signed 32-bit\ninteger.  It starts with the value '80000001'h,\nor -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\nThus, a typical sequence number will be very negative.\nIt is used to detect old and duplicate Link State\nAdvertisements.  The space of sequence numbers is linearly\nordered.  The larger the sequence number, the more recent\nthe advertisement.")
ospfLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAge.setDescription("This field is the age of the link state advertisement\nin seconds.")
ospfLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbChecksum.setDescription("This field is the checksum of the complete contents of\nthe advertisement, excepting the age field.  The age field\nis excepted so that an advertisement's age can be\nincremented without updating the checksum.  The checksum\nused is the same that is used for ISO connectionless\n\n\n\ndatagrams; it is commonly referred to as the\nFletcher checksum.")
ospfLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 4, 1, 8), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLsdbAdvertisement.setDescription("The entire link state advertisement, including\nits header.\n\nNote that for variable length LSAs, SNMP agents\nmay not be able to return the largest string size.")
ospfAreaRangeTable = MibTable((1, 3, 6, 1, 2, 1, 14, 5))
if mibBuilder.loadTexts: ospfAreaRangeTable.setDescription("The Address Range Table acts as an adjunct to the Area\nTable.  It describes those Address Range Summaries that\nare configured to be propagated from an Area to reduce\nthe amount of information about it that is known beyond\nits borders.  It contains a set of IP address ranges\nspecified by an IP address/IP network mask pair.\nFor example, class B address range of X.X.X.X\nwith a network mask of 255.255.0.0 includes all IP\naddresses from X.X.0.0 to X.X.255.255.\n\nNote that this table is obsoleted and is replaced\nby the Area Aggregate Table.")
ospfAreaRangeEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 5, 1)).setIndexNames((0, "OSPF-MIB", "ospfAreaRangeAreaId"), (0, "OSPF-MIB", "ospfAreaRangeNet"))
if mibBuilder.loadTexts: ospfAreaRangeEntry.setDescription("A single area address range.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\nstorage.")
ospfAreaRangeAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaRangeAreaId.setDescription("The area that the address range is to be found\nwithin.")
ospfAreaRangeNet = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaRangeNet.setDescription("The IP address of the net or subnet indicated\nby the range.")
ospfAreaRangeMask = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 3), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaRangeMask.setDescription("The subnet mask that pertains to the net or\nsubnet.")
ospfAreaRangeStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaRangeStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfAreaRangeEffect = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 5, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("advertiseMatching", 1), ("doNotAdvertiseMatching", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaRangeEffect.setDescription("Subnets subsumed by ranges either trigger the\nadvertisement of the indicated summary\n(advertiseMatching) or result in the subnet's not\nbeing advertised at all outside the area.")
ospfHostTable = MibTable((1, 3, 6, 1, 2, 1, 14, 6))
if mibBuilder.loadTexts: ospfHostTable.setDescription("The Host/Metric Table indicates what hosts are directly\n\n\n\nattached to the router, what metrics and types\nof service should be advertised for them,\nand what areas they are found within.")
ospfHostEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 6, 1)).setIndexNames((0, "OSPF-MIB", "ospfHostIpAddress"), (0, "OSPF-MIB", "ospfHostTOS"))
if mibBuilder.loadTexts: ospfHostEntry.setDescription("A metric to be advertised, for a given type of\nservice, when a given host is reachable.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\nstorage.")
ospfHostIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfHostIpAddress.setDescription("The IP address of the host.")
ospfHostTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 2), TOSType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfHostTOS.setDescription("The Type of Service of the route being configured.")
ospfHostMetric = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 3), Metric()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfHostMetric.setDescription("The metric to be advertised.")
ospfHostStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 4), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfHostStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfHostAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 5), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfHostAreaID.setDescription("The OSPF area to which the host belongs.\nDeprecated by ospfHostCfgAreaID.")
ospfHostCfgAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 6, 1, 6), AreaID()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfHostCfgAreaID.setDescription("To configure the OSPF area to which the host belongs.")
ospfIfTable = MibTable((1, 3, 6, 1, 2, 1, 14, 7))
if mibBuilder.loadTexts: ospfIfTable.setDescription("The OSPF Interface Table describes the interfaces\nfrom the viewpoint of OSPF.\nIt augments the ipAddrTable with OSPF specific information.")
ospfIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 7, 1)).setIndexNames((0, "OSPF-MIB", "ospfIfIpAddress"), (0, "OSPF-MIB", "ospfAddressLessIf"))
if mibBuilder.loadTexts: ospfIfEntry.setDescription("The OSPF interface entry describes one interface\nfrom the viewpoint of OSPF.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\nstorage.")
ospfIfIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfIpAddress.setDescription("The IP address of this OSPF interface.")
ospfAddressLessIf = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAddressLessIf.setDescription("For the purpose of easing the instancing of\naddressed and addressless interfaces; this\nvariable takes the value 0 on interfaces with\nIP addresses and the corresponding value of\nifIndex for interfaces having no IP address.")
ospfIfAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 3), AreaID().clone(hexValue='00000000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfAreaId.setDescription("A 32-bit integer uniquely identifying the area\nto which the interface connects.  Area ID\n0.0.0.0 is used for the OSPF backbone.")
ospfIfType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,5,3,)).subtype(namedValues=NamedValues(("broadcast", 1), ("nbma", 2), ("pointToPoint", 3), ("pointToMultipoint", 5), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfType.setDescription("The OSPF interface type.\nBy way of a default, this field may be intuited\nfrom the corresponding value of ifType.\nBroadcast LANs, such as Ethernet and IEEE 802.5,\ntake the value 'broadcast', X.25 and similar\ntechnologies take the value 'nbma', and links\nthat are definitively point to point take the\nvalue 'pointToPoint'.")
ospfIfAdminStat = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 5), Status().clone('enabled')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfAdminStat.setDescription("The OSPF interface's administrative status.\nThe value formed on the interface, and the interface\nwill be advertised as an internal route to some area.\nThe value 'disabled' denotes that the interface is\nexternal to OSPF.")
ospfIfRtrPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 6), DesignatedRouterPriority().clone('1')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfRtrPriority.setDescription("The priority of this interface.  Used in\nmulti-access networks, this field is used in\nthe designated router election algorithm.  The\nvalue 0 signifies that the router is not eligible\nto become the designated router on this particular\nnetwork.  In the event of a tie in this value,\nrouters will use their Router ID as a tie breaker.")
ospfIfTransitDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 7), UpToMaxAge().clone('1')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfTransitDelay.setDescription("The estimated number of seconds it takes to\ntransmit a link state update packet over this\ninterface.  Note that the minimal value SHOULD be\n1 second.")
ospfIfRetransInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 8), UpToMaxAge().clone('5')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfRetransInterval.setDescription("The number of seconds between link state advertisement\nretransmissions, for adjacencies belonging to this\ninterface.  This value is also used when retransmitting\n\n\n\ndatabase description and Link State request packets.\nNote that minimal value SHOULD be 1 second.")
ospfIfHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 9), HelloRange().clone('10')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfHelloInterval.setDescription("The length of time, in seconds, between the Hello packets\nthat the router sends on the interface.  This value must be\nthe same for all routers attached to a common network.")
ospfIfRtrDeadInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 10), PositiveInteger().clone('40')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfRtrDeadInterval.setDescription("The number of seconds that a router's Hello packets have\nnot been seen before its neighbors declare the router down.\nThis should be some multiple of the Hello interval.  This\nvalue must be the same for all routers attached to a common\nnetwork.")
ospfIfPollInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 11), PositiveInteger().clone('120')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfPollInterval.setDescription("The larger time interval, in seconds, between the Hello\npackets sent to an inactive non-broadcast multi-access\nneighbor.")
ospfIfState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(1,5,3,6,7,2,4,)).subtype(namedValues=NamedValues(("down", 1), ("loopback", 2), ("waiting", 3), ("pointToPoint", 4), ("designatedRouter", 5), ("backupDesignatedRouter", 6), ("otherDesignatedRouter", 7), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfState.setDescription("The OSPF Interface State.")
ospfIfDesignatedRouter = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 13), IpAddress().clone("0.0.0.0")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfDesignatedRouter.setDescription("The IP address of the designated router.")
ospfIfBackupDesignatedRouter = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 14), IpAddress().clone("0.0.0.0")).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfBackupDesignatedRouter.setDescription("The IP address of the backup designated\nrouter.")
ospfIfEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfEvents.setDescription("The number of times this OSPF interface has\nchanged its state or an error has occurred.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at other\ntimes as indicated by the value of ospfDiscontinuityTime.")
ospfIfAuthKey = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 16), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 256)).clone(hexValue='0000000000000000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfAuthKey.setDescription("The cleartext password used as an OSPF\nauthentication key when simplePassword security\nis enabled.  This object does not access any OSPF\ncryptogaphic (e.g., MD5) authentication key under\nany circumstance.\n\nIf the key length is shorter than 8 octets, the\nagent will left adjust and zero fill to 8 octets.\n\nUnauthenticated interfaces need no authentication\nkey, and simple password authentication cannot use\na key of more than 8 octets.\n\nNote that the use of simplePassword authentication\nis NOT recommended when there is concern regarding\nattack upon the OSPF system.  SimplePassword\nauthentication is only sufficient to protect against\naccidental misconfigurations because it re-uses\ncleartext passwords [RFC1704].\n\nWhen read, ospfIfAuthKey always returns an octet\nstring of length zero.")
ospfIfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 17), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfIfMulticastForwarding = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 18), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("blocked", 1), ("multicast", 2), ("unicast", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfMulticastForwarding.setDescription("The way multicasts should be forwarded on this\ninterface: not forwarded, forwarded as data\nlink multicasts, or forwarded as data link\nunicasts.  Data link multicasting is not\nmeaningful on point-to-point and NBMA interfaces,\nand setting ospfMulticastForwarding to 0 effectively\ndisables all multicast forwarding.")
ospfIfDemand = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 19), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfDemand.setDescription("Indicates whether Demand OSPF procedures (hello\nsuppression to FULL neighbors and setting the\nDoNotAge flag on propagated LSAs) should be\nperformed on this interface.")
ospfIfAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 20), OspfAuthenticationType().clone('none')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfAuthType.setDescription("The authentication type specified for an interface.\n\nNote that this object can be used to engage\nin significant attacks against an OSPF router.")
ospfIfLsaCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfLsaCount.setDescription("The total number of link-local link state advertisements\nin this interface's link-local link state database.")
ospfIfLsaCksumSum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 22), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfLsaCksumSum.setDescription("The 32-bit unsigned sum of the Link State\nAdvertisements' LS checksums contained in this\ninterface's link-local link state database.\nThe sum can be used to determine if there has\nbeen a change in the interface's link state\ndatabase and to compare the interface link state\ndatabase of routers attached to the same subnet.")
ospfIfDesignatedRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 23), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfDesignatedRouterId.setDescription("The Router ID of the designated router.")
ospfIfBackupDesignatedRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 7, 1, 24), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfBackupDesignatedRouterId.setDescription("The Router ID of the backup designated router.")
ospfIfMetricTable = MibTable((1, 3, 6, 1, 2, 1, 14, 8))
if mibBuilder.loadTexts: ospfIfMetricTable.setDescription("The Metric Table describes the metrics to be advertised\nfor a specified interface at the various types of service.\nAs such, this table is an adjunct of the OSPF Interface\nTable.\n\nTypes of service, as defined by RFC 791, have the ability\nto request low delay, high bandwidth, or reliable linkage.\n\nFor the purposes of this specification, the measure of\nbandwidth:\n\n\n\n\nMetric = referenceBandwidth / ifSpeed\n\nis the default value.\nThe default reference bandwidth is 10^8.\nFor multiple link interfaces, note that ifSpeed is the sum\nof the individual link speeds.  This yields a number having\nthe following typical values:\n\nNetwork Type/bit rate   Metric\n\n>= 100 MBPS                 1\nEthernet/802.3             10\nE1                         48\nT1 (ESF)                   65\n64 KBPS                    1562\n56 KBPS                    1785\n19.2 KBPS                  5208\n9.6 KBPS                   10416\n\nRoutes that are not specified use the default\n(TOS 0) metric.\n\nNote that the default reference bandwidth can be configured\nusing the general group object ospfReferenceBandwidth.")
ospfIfMetricEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 8, 1)).setIndexNames((0, "OSPF-MIB", "ospfIfMetricIpAddress"), (0, "OSPF-MIB", "ospfIfMetricAddressLessIf"), (0, "OSPF-MIB", "ospfIfMetricTOS"))
if mibBuilder.loadTexts: ospfIfMetricEntry.setDescription("A particular TOS metric for a non-virtual interface\nidentified by the interface index.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\nstorage.")
ospfIfMetricIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfMetricIpAddress.setDescription("The IP address of this OSPF interface.  On row\ncreation, this can be derived from the instance.")
ospfIfMetricAddressLessIf = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfMetricAddressLessIf.setDescription("For the purpose of easing the instancing of\naddressed and addressless interfaces; this\nvariable takes the value 0 on interfaces with\nIP addresses and the value of ifIndex for\ninterfaces having no IP address.  On row\ncreation, this can be derived from the instance.")
ospfIfMetricTOS = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 3), TOSType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfIfMetricTOS.setDescription("The Type of Service metric being referenced.\nOn row creation, this can be derived from the\ninstance.")
ospfIfMetricValue = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 4), Metric()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfMetricValue.setDescription("The metric of using this Type of Service on\nthis interface.  The default value of the TOS 0\nmetric is 10^8 / ifSpeed.")
ospfIfMetricStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 8, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfIfMetricStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfVirtIfTable = MibTable((1, 3, 6, 1, 2, 1, 14, 9))
if mibBuilder.loadTexts: ospfVirtIfTable.setDescription("Information about this router's virtual interfaces\nthat the OSPF Process is configured to carry on.")
ospfVirtIfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 9, 1)).setIndexNames((0, "OSPF-MIB", "ospfVirtIfAreaId"), (0, "OSPF-MIB", "ospfVirtIfNeighbor"))
if mibBuilder.loadTexts: ospfVirtIfEntry.setDescription("Information about a single virtual interface.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\nstorage.")
ospfVirtIfAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfAreaId.setDescription("The transit area that the virtual link\ntraverses.  By definition, this is not 0.0.0.0.")
ospfVirtIfNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 2), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfNeighbor.setDescription("The Router ID of the virtual neighbor.")
ospfVirtIfTransitDelay = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 3), UpToMaxAge().clone('1')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfTransitDelay.setDescription("The estimated number of seconds it takes to\ntransmit a Link State update packet over this\ninterface.  Note that the minimal value SHOULD be\n1 second.")
ospfVirtIfRetransInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 4), UpToMaxAge().clone('5')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfRetransInterval.setDescription("The number of seconds between link state\navertisement retransmissions, for adjacencies\nbelonging to this interface.  This value is\nalso used when retransmitting database\ndescription and Link State request packets.  This\nvalue should be well over the expected\nround-trip time.  Note that the minimal value SHOULD be\n1 second.")
ospfVirtIfHelloInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 5), HelloRange().clone('10')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfHelloInterval.setDescription("The length of time, in seconds, between the\nHello packets that the router sends on the\ninterface.  This value must be the same for the\nvirtual neighbor.")
ospfVirtIfRtrDeadInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 6), PositiveInteger().clone('60')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfRtrDeadInterval.setDescription("The number of seconds that a router's Hello\npackets have not been seen before its\nneighbors declare the router down.  This should be\nsome multiple of the Hello interval.  This\nvalue must be the same for the virtual neighbor.")
ospfVirtIfState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(1,4,)).subtype(namedValues=NamedValues(("down", 1), ("pointToPoint", 4), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfState.setDescription("OSPF virtual interface states.")
ospfVirtIfEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfEvents.setDescription("The number of state changes or error events on\nthis virtual link.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at other\ntimes as indicated by the value of ospfDiscontinuityTime.")
ospfVirtIfAuthKey = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(0, 256)).clone(hexValue='0000000000000000')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfAuthKey.setDescription("The cleartext password used as an OSPF\nauthentication key when simplePassword security\nis enabled.  This object does not access any OSPF\ncryptogaphic (e.g., MD5) authentication key under\nany circumstance.\n\n\n\nIf the key length is shorter than 8 octets, the\nagent will left adjust and zero fill to 8 octets.\n\nUnauthenticated interfaces need no authentication\nkey, and simple password authentication cannot use\na key of more than 8 octets.\n\nNote that the use of simplePassword authentication\nis NOT recommended when there is concern regarding\nattack upon the OSPF system.  SimplePassword\nauthentication is only sufficient to protect against\naccidental misconfigurations because it re-uses\ncleartext passwords.  [RFC1704]\n\nWhen read, ospfIfAuthKey always returns an octet\nstring of length zero.")
ospfVirtIfStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfVirtIfAuthType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 11), OspfAuthenticationType().clone('none')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfVirtIfAuthType.setDescription("The authentication type specified for a virtual interface.\n\nNote that this object can be used to engage\nin significant attacks against an OSPF router.")
ospfVirtIfLsaCount = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 12), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfLsaCount.setDescription("The total number of link-local link state advertisements\nin this virtual interface's link-local link state database.")
ospfVirtIfLsaCksumSum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 9, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtIfLsaCksumSum.setDescription("The 32-bit unsigned sum of the link state\nadvertisements' LS checksums contained in this\nvirtual interface's link-local link state database.\nThe sum can be used to determine if there has\nbeen a change in the virtual interface's link state\ndatabase, and to compare the virtual interface\nlink state database of the virtual neighbors.")
ospfNbrTable = MibTable((1, 3, 6, 1, 2, 1, 14, 10))
if mibBuilder.loadTexts: ospfNbrTable.setDescription("A table describing all non-virtual neighbors\nin the locality of the OSPF router.")
ospfNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 10, 1)).setIndexNames((0, "OSPF-MIB", "ospfNbrIpAddr"), (0, "OSPF-MIB", "ospfNbrAddressLessIndex"))
if mibBuilder.loadTexts: ospfNbrEntry.setDescription("The information regarding a single neighbor.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\n\n\n\nstorage.")
ospfNbrIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrIpAddr.setDescription("The IP address this neighbor is using in its\nIP source address.  Note that, on addressless\nlinks, this will not be 0.0.0.0 but the\n\n\n\naddress of another of the neighbor's interfaces.")
ospfNbrAddressLessIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 2), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrAddressLessIndex.setDescription("On an interface having an IP address, zero.\nOn addressless interfaces, the corresponding\nvalue of ifIndex in the Internet Standard MIB.\nOn row creation, this can be derived from the\ninstance.")
ospfNbrRtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 3), RouterID().clone(hexValue='00000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRtrId.setDescription("A 32-bit integer (represented as a type\nIpAddress) uniquely identifying the neighboring\nrouter in the Autonomous System.")
ospfNbrOptions = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 4), Integer32().clone(0)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrOptions.setDescription("A bit mask corresponding to the neighbor's\noptions field.\n\nBit 0, if set, indicates that the system will\noperate on Type of Service metrics other than\nTOS 0.  If zero, the neighbor will ignore all\nmetrics except the TOS 0 metric.\n\nBit 1, if set, indicates that the associated\narea accepts and operates on external\ninformation; if zero, it is a stub area.\n\nBit 2, if set, indicates that the system is\ncapable of routing IP multicast datagrams, that is\nthat it implements the multicast extensions to\nOSPF.\n\n\n\nBit 3, if set, indicates that the associated\narea is an NSSA.  These areas are capable of\ncarrying type-7 external advertisements, which\nare translated into type-5 external advertisements\nat NSSA borders.")
ospfNbrPriority = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 5), DesignatedRouterPriority().clone('1')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfNbrPriority.setDescription("The priority of this neighbor in the designated\nrouter election algorithm.  The value 0 signifies\nthat the neighbor is not eligible to become\nthe designated router on this particular network.")
ospfNbrState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,5,3,7,2,8,6,4,)).subtype(namedValues=NamedValues(("down", 1), ("attempt", 2), ("init", 3), ("twoWay", 4), ("exchangeStart", 5), ("exchange", 6), ("loading", 7), ("full", 8), )).clone(1)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrState.setDescription("The state of the relationship with this neighbor.")
ospfNbrEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrEvents.setDescription("The number of times this neighbor relationship\nhas changed state or an error has occurred.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at other\ntimes as indicated by the value of ospfDiscontinuityTime.")
ospfNbrLsRetransQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 8), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrLsRetransQLen.setDescription("The current length of the retransmission\nqueue.")
ospfNbmaNbrStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 9), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfNbmaNbrStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfNbmaNbrPermanence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 10), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("dynamic", 1), ("permanent", 2), )).clone(2)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbmaNbrPermanence.setDescription("This variable displays the status of the entry;\n'dynamic' and 'permanent' refer to how the neighbor\nbecame known.")
ospfNbrHelloSuppressed = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 11), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrHelloSuppressed.setDescription("Indicates whether Hellos are being suppressed\nto the neighbor.")
ospfNbrRestartHelperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 12), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("notHelping", 1), ("helping", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRestartHelperStatus.setDescription("Indicates whether the router is acting\nas a graceful restart helper for the neighbor.")
ospfNbrRestartHelperAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 13), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRestartHelperAge.setDescription("Remaining time in current OSPF graceful restart\ninterval, if the router is acting as a restart\nhelper for the neighbor.")
ospfNbrRestartHelperExitReason = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 10, 1, 14), Integer().subtype(subtypeSpec=SingleValueConstraint(1,5,3,4,2,)).subtype(namedValues=NamedValues(("none", 1), ("inProgress", 2), ("completed", 3), ("timedOut", 4), ("topologyChanged", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfNbrRestartHelperExitReason.setDescription("Describes the outcome of the last attempt at acting\nas a graceful restart helper for the neighbor.")
ospfVirtNbrTable = MibTable((1, 3, 6, 1, 2, 1, 14, 11))
if mibBuilder.loadTexts: ospfVirtNbrTable.setDescription("This table describes all virtual neighbors.\nSince virtual links are configured\nin the Virtual Interface Table, this table is read-only.")
ospfVirtNbrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 11, 1)).setIndexNames((0, "OSPF-MIB", "ospfVirtNbrArea"), (0, "OSPF-MIB", "ospfVirtNbrRtrId"))
if mibBuilder.loadTexts: ospfVirtNbrEntry.setDescription("Virtual neighbor information.")
ospfVirtNbrArea = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrArea.setDescription("The Transit Area Identifier.")
ospfVirtNbrRtrId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 2), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRtrId.setDescription("A 32-bit integer uniquely identifying the\nneighboring router in the Autonomous System.")
ospfVirtNbrIpAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrIpAddr.setDescription("The IP address this virtual neighbor is using.")
ospfVirtNbrOptions = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrOptions.setDescription("A bit mask corresponding to the neighbor's\noptions field.\n\nBit 1, if set, indicates that the system will\noperate on Type of Service metrics other than\nTOS 0.  If zero, the neighbor will ignore all\nmetrics except the TOS 0 metric.\n\nBit 2, if set, indicates that the system is\nnetwork multicast capable, i.e., that it\nimplements OSPF multicast routing.")
ospfVirtNbrState = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,5,3,7,2,8,6,4,)).subtype(namedValues=NamedValues(("down", 1), ("attempt", 2), ("init", 3), ("twoWay", 4), ("exchangeStart", 5), ("exchange", 6), ("loading", 7), ("full", 8), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrState.setDescription("The state of the virtual neighbor relationship.")
ospfVirtNbrEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrEvents.setDescription("The number of times this virtual link has\nchanged its state or an error has occurred.\n\nDiscontinuities in the value of this counter can occur\nat re-initialization of the management system, and at other\ntimes as indicated by the value of ospfDiscontinuityTime.")
ospfVirtNbrLsRetransQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 7), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrLsRetransQLen.setDescription("The current length of the retransmission\nqueue.")
ospfVirtNbrHelloSuppressed = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 8), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrHelloSuppressed.setDescription("Indicates whether Hellos are being suppressed\nto the neighbor.")
ospfVirtNbrRestartHelperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 9), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("notHelping", 1), ("helping", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRestartHelperStatus.setDescription("Indicates whether the router is acting\nas a graceful restart helper for the neighbor.")
ospfVirtNbrRestartHelperAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 10), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRestartHelperAge.setDescription("Remaining time in current OSPF graceful restart\ninterval, if the router is acting as a restart\nhelper for the neighbor.")
ospfVirtNbrRestartHelperExitReason = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 11, 1, 11), Integer().subtype(subtypeSpec=SingleValueConstraint(1,5,3,4,2,)).subtype(namedValues=NamedValues(("none", 1), ("inProgress", 2), ("completed", 3), ("timedOut", 4), ("topologyChanged", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtNbrRestartHelperExitReason.setDescription("Describes the outcome of the last attempt at acting\nas a graceful restart helper for the neighbor.")
ospfExtLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 12))
if mibBuilder.loadTexts: ospfExtLsdbTable.setDescription("The OSPF Process's external LSA link state database.\n\nThis table is identical to the OSPF LSDB Table\nin format, but contains only external link state\nadvertisements.  The purpose is to allow external\n\n\n\nLSAs to be displayed once for the router rather\nthan once in each non-stub area.\n\nNote that external LSAs are also in the AS-scope link state\ndatabase.")
ospfExtLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 12, 1)).setIndexNames((0, "OSPF-MIB", "ospfExtLsdbType"), (0, "OSPF-MIB", "ospfExtLsdbLsid"), (0, "OSPF-MIB", "ospfExtLsdbRouterId"))
if mibBuilder.loadTexts: ospfExtLsdbEntry.setDescription("A single link state advertisement.")
ospfExtLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(5,)).subtype(namedValues=NamedValues(("asExternalLink", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbType.setDescription("The type of the link state advertisement.\nEach link state type has a separate advertisement\nformat.")
ospfExtLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 2), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbLsid.setDescription("The Link State ID is an LS Type Specific field\ncontaining either a Router ID or an IP address;\nit identifies the piece of the routing domain\nthat is being described by the advertisement.")
ospfExtLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 3), RouterID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbRouterId.setDescription("The 32-bit number that uniquely identifies the\noriginating router in the Autonomous System.")
ospfExtLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbSequence.setDescription("The sequence number field is a signed 32-bit\ninteger.  It starts with the value '80000001'h,\nor -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\nThus, a typical sequence number will be very negative.\nIt is used to detect old and duplicate link state\nadvertisements.  The space of sequence numbers is linearly\nordered.  The larger the sequence number, the more recent\nthe advertisement.")
ospfExtLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbAge.setDescription("This field is the age of the link state\nadvertisement in seconds.")
ospfExtLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbChecksum.setDescription("This field is the checksum of the complete\ncontents of the advertisement, excepting the\nage field.  The age field is excepted so that\nan advertisement's age can be incremented\nwithout updating the checksum.  The checksum\nused is the same that is used for ISO\nconnectionless datagrams; it is commonly referred\nto as the Fletcher checksum.")
ospfExtLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 12, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(36, 36)).setFixedLength(36)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfExtLsdbAdvertisement.setDescription("The entire link state advertisement, including\nits header.")
ospfRouteGroup = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13))
ospfIntraArea = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13, 1))
ospfInterArea = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13, 2))
ospfExternalType1 = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13, 3))
ospfExternalType2 = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 13, 4))
ospfAreaAggregateTable = MibTable((1, 3, 6, 1, 2, 1, 14, 14))
if mibBuilder.loadTexts: ospfAreaAggregateTable.setDescription("The Area Aggregate Table acts as an adjunct\nto the Area Table.  It describes those address aggregates\nthat are configured to be propagated from an area.\nIts purpose is to reduce the amount of information\nthat is known beyond an Area's borders.\n\nIt contains a set of IP address ranges\nspecified by an IP address/IP network mask pair.\nFor example, a class B address range of X.X.X.X\nwith a network mask of 255.255.0.0 includes all IP\naddresses from X.X.0.0 to X.X.255.255.\n\nNote that if ranges are configured such that one range\nsubsumes another range (e.g., 10.0.0.0 mask 255.0.0.0\nand 10.1.0.0 mask 255.255.0.0),\nthe most specific match is the preferred one.")
ospfAreaAggregateEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 14, 1)).setIndexNames((0, "OSPF-MIB", "ospfAreaAggregateAreaID"), (0, "OSPF-MIB", "ospfAreaAggregateLsdbType"), (0, "OSPF-MIB", "ospfAreaAggregateNet"), (0, "OSPF-MIB", "ospfAreaAggregateMask"))
if mibBuilder.loadTexts: ospfAreaAggregateEntry.setDescription("A single area aggregate entry.\n\nInformation in this table is persistent and when this object\nis written the entity SHOULD save the change to non-volatile\nstorage.")
ospfAreaAggregateAreaID = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 1), AreaID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaAggregateAreaID.setDescription("The area within which the address aggregate is to be\nfound.")
ospfAreaAggregateLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(7,3,)).subtype(namedValues=NamedValues(("summaryLink", 3), ("nssaExternalLink", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaAggregateLsdbType.setDescription("The type of the address aggregate.  This field\nspecifies the Lsdb type that this address\naggregate applies to.")
ospfAreaAggregateNet = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaAggregateNet.setDescription("The IP address of the net or subnet indicated\nby the range.")
ospfAreaAggregateMask = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 4), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaAggregateMask.setDescription("The subnet mask that pertains to the net or\nsubnet.")
ospfAreaAggregateStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 5), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaAggregateStatus.setDescription("This object permits management of the table by\nfacilitating actions such as row creation,\nconstruction, and destruction.\n\nThe value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
ospfAreaAggregateEffect = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("advertiseMatching", 1), ("doNotAdvertiseMatching", 2), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaAggregateEffect.setDescription("Subnets subsumed by ranges either trigger the\nadvertisement of the indicated aggregate\n(advertiseMatching) or result in the subnet's not\nbeing advertised at all outside the area.")
ospfAreaAggregateExtRouteTag = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 14, 1, 7), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ospfAreaAggregateExtRouteTag.setDescription("External route tag to be included in NSSA (type-7)\nLSAs.")
ospfConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 15))
ospfGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 15, 1))
ospfCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 14, 15, 2))
ospfLocalLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 17))
if mibBuilder.loadTexts: ospfLocalLsdbTable.setDescription("The OSPF Process's link-local link state database\nfor non-virtual links.\nThis table is identical to the OSPF LSDB Table\nin format, but contains only link-local Link State\nAdvertisements for non-virtual links.  The purpose is\nto allow link-local LSAs to be displayed for each\nnon-virtual interface.  This table is implemented to\nsupport type-9 LSAs that are defined\nin 'The OSPF Opaque LSA Option'.")
ospfLocalLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 17, 1)).setIndexNames((0, "OSPF-MIB", "ospfLocalLsdbIpAddress"), (0, "OSPF-MIB", "ospfLocalLsdbAddressLessIf"), (0, "OSPF-MIB", "ospfLocalLsdbType"), (0, "OSPF-MIB", "ospfLocalLsdbLsid"), (0, "OSPF-MIB", "ospfLocalLsdbRouterId"))
if mibBuilder.loadTexts: ospfLocalLsdbEntry.setDescription("A single link state advertisement.")
ospfLocalLsdbIpAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 1), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfLocalLsdbIpAddress.setDescription("The IP address of the interface from\nwhich the LSA was received if the interface is\nnumbered.")
ospfLocalLsdbAddressLessIf = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 2), InterfaceIndexOrZero()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfLocalLsdbAddressLessIf.setDescription("The interface index of the interface from\nwhich the LSA was received if the interface is\nunnumbered.")
ospfLocalLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(9,)).subtype(namedValues=NamedValues(("localOpaqueLink", 9), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfLocalLsdbType.setDescription("The type of the link state advertisement.\nEach link state type has a separate\nadvertisement format.")
ospfLocalLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 4), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfLocalLsdbLsid.setDescription("The Link State ID is an LS Type Specific field\ncontaining a 32-bit identifier in IP address format;\nit identifies the piece of the routing domain\nthat is being described by the advertisement.")
ospfLocalLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 5), RouterID()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfLocalLsdbRouterId.setDescription("The 32-bit number that uniquely identifies the\noriginating router in the Autonomous System.")
ospfLocalLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLocalLsdbSequence.setDescription("The sequence number field is a signed 32-bit\ninteger.  It starts with the value '80000001'h,\nor -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\nThus, a typical sequence number will be very negative.\nIt is used to detect old and duplicate link state\nadvertisements.  The space of sequence numbers is linearly\nordered.  The larger the sequence number, the more recent\nthe advertisement.")
ospfLocalLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLocalLsdbAge.setDescription("This field is the age of the link state\nadvertisement in seconds.")
ospfLocalLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLocalLsdbChecksum.setDescription("This field is the checksum of the complete\ncontents of the advertisement, excepting the\nage field.  The age field is excepted so that\nan advertisement's age can be incremented\nwithout updating the checksum.  The checksum\nused is the same that is used for ISO\nconnectionless datagrams; it is commonly referred\nto as the Fletcher checksum.")
ospfLocalLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 17, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfLocalLsdbAdvertisement.setDescription("The entire link state advertisement, including\nits header.\n\nNote that for variable length LSAs, SNMP agents\nmay not be able to return the largest string size.")
ospfVirtLocalLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 18))
if mibBuilder.loadTexts: ospfVirtLocalLsdbTable.setDescription("The OSPF Process's link-local link state database\nfor virtual links.\n\n\n\n\nThis table is identical to the OSPF LSDB Table\nin format, but contains only link-local Link State\nAdvertisements for virtual links.  The purpose is to\nallow link-local LSAs to be displayed for each virtual\ninterface.  This table is implemented to support type-9 LSAs\nthat are defined in 'The OSPF Opaque LSA Option'.")
ospfVirtLocalLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 18, 1)).setIndexNames((0, "OSPF-MIB", "ospfVirtLocalLsdbTransitArea"), (0, "OSPF-MIB", "ospfVirtLocalLsdbNeighbor"), (0, "OSPF-MIB", "ospfVirtLocalLsdbType"), (0, "OSPF-MIB", "ospfVirtLocalLsdbLsid"), (0, "OSPF-MIB", "ospfVirtLocalLsdbRouterId"))
if mibBuilder.loadTexts: ospfVirtLocalLsdbEntry.setDescription("A single link state advertisement.")
ospfVirtLocalLsdbTransitArea = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 1), AreaID()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfVirtLocalLsdbTransitArea.setDescription("The transit area that the virtual link\ntraverses.  By definition, this is not 0.0.0.0.")
ospfVirtLocalLsdbNeighbor = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 2), RouterID()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfVirtLocalLsdbNeighbor.setDescription("The Router ID of the virtual neighbor.")
ospfVirtLocalLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(9,)).subtype(namedValues=NamedValues(("localOpaqueLink", 9), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfVirtLocalLsdbType.setDescription("The type of the link state advertisement.\nEach link state type has a separate\nadvertisement format.")
ospfVirtLocalLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 4), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfVirtLocalLsdbLsid.setDescription("The Link State ID is an LS Type Specific field\ncontaining a 32-bit identifier in IP address format;\nit identifies the piece of the routing domain\nthat is being described by the advertisement.")
ospfVirtLocalLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 5), RouterID()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfVirtLocalLsdbRouterId.setDescription("The 32-bit number that uniquely identifies the\noriginating router in the Autonomous System.")
ospfVirtLocalLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtLocalLsdbSequence.setDescription("The sequence number field is a signed 32-bit\ninteger.  It starts with the value '80000001'h,\nor -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\nThus, a typical sequence number will be very negative.\nIt is used to detect old and duplicate link state\nadvertisements.  The space of sequence numbers is linearly\nordered.  The larger the sequence number, the more recent\nthe advertisement.")
ospfVirtLocalLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 7), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtLocalLsdbAge.setDescription("This field is the age of the link state\nadvertisement in seconds.")
ospfVirtLocalLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 8), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtLocalLsdbChecksum.setDescription("This field is the checksum of the complete\ncontents of the advertisement, excepting the\nage field.  The age field is excepted so that\n\n\n\nan advertisement's age can be incremented\nwithout updating the checksum.  The checksum\nused is the same that is used for ISO\nconnectionless datagrams; it is commonly\nreferred to as the Fletcher checksum.")
ospfVirtLocalLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 18, 1, 9), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfVirtLocalLsdbAdvertisement.setDescription("The entire link state advertisement, including\nits header.")
ospfAsLsdbTable = MibTable((1, 3, 6, 1, 2, 1, 14, 19))
if mibBuilder.loadTexts: ospfAsLsdbTable.setDescription("The OSPF Process's AS-scope LSA link state database.\nThe database contains the AS-scope Link State\nAdvertisements from throughout the areas that\nthe device is attached to.\n\nThis table is identical to the OSPF LSDB Table\nin format, but contains only AS-scope Link State\nAdvertisements.  The purpose is to allow AS-scope\nLSAs to be displayed once for the router rather\nthan once in each non-stub area.")
ospfAsLsdbEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 19, 1)).setIndexNames((0, "OSPF-MIB", "ospfAsLsdbType"), (0, "OSPF-MIB", "ospfAsLsdbLsid"), (0, "OSPF-MIB", "ospfAsLsdbRouterId"))
if mibBuilder.loadTexts: ospfAsLsdbEntry.setDescription("A single link state advertisement.")
ospfAsLsdbType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(11,5,)).subtype(namedValues=NamedValues(("asOpaqueLink", 11), ("asExternalLink", 5), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfAsLsdbType.setDescription("The type of the link state advertisement.\nEach link state type has a separate\nadvertisement format.")
ospfAsLsdbLsid = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 2), IpAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfAsLsdbLsid.setDescription("The Link State ID is an LS Type Specific field\ncontaining either a Router ID or an IP address;\n\n\n\nit identifies the piece of the routing domain\nthat is being described by the advertisement.")
ospfAsLsdbRouterId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 3), RouterID()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfAsLsdbRouterId.setDescription("The 32-bit number that uniquely identifies the\noriginating router in the Autonomous System.")
ospfAsLsdbSequence = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsdbSequence.setDescription("The sequence number field is a signed 32-bit\ninteger.  It starts with the value '80000001'h,\nor -'7FFFFFFF'h, and increments until '7FFFFFFF'h.\nThus, a typical sequence number will be very negative.\nIt is used to detect old and duplicate link state\nadvertisements.  The space of sequence numbers is linearly\nordered.  The larger the sequence number, the more recent\nthe advertisement.")
ospfAsLsdbAge = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 5), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsdbAge.setDescription("This field is the age of the link state\nadvertisement in seconds.")
ospfAsLsdbChecksum = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 6), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsdbChecksum.setDescription("This field is the checksum of the complete\ncontents of the advertisement, excepting the\nage field.  The age field is excepted so that\nan advertisement's age can be incremented\nwithout updating the checksum.  The checksum\nused is the same that is used for ISO\nconnectionless datagrams; it is commonly referred\nto as the Fletcher checksum.")
ospfAsLsdbAdvertisement = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 19, 1, 7), OctetString().subtype(subtypeSpec=ValueSizeConstraint(1, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAsLsdbAdvertisement.setDescription("The entire link state advertisement, including\nits header.")
ospfAreaLsaCountTable = MibTable((1, 3, 6, 1, 2, 1, 14, 20))
if mibBuilder.loadTexts: ospfAreaLsaCountTable.setDescription("This table maintains per-area, per-LSA-type counters")
ospfAreaLsaCountEntry = MibTableRow((1, 3, 6, 1, 2, 1, 14, 20, 1)).setIndexNames((0, "OSPF-MIB", "ospfAreaLsaCountAreaId"), (0, "OSPF-MIB", "ospfAreaLsaCountLsaType"))
if mibBuilder.loadTexts: ospfAreaLsaCountEntry.setDescription("An entry with a number of link advertisements\n\n\n\nof a given type for a given area.")
ospfAreaLsaCountAreaId = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 20, 1, 1), AreaID()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfAreaLsaCountAreaId.setDescription("This entry Area ID.")
ospfAreaLsaCountLsaType = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 20, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,4,10,7,2,6,)).subtype(namedValues=NamedValues(("routerLink", 1), ("areaOpaqueLink", 10), ("networkLink", 2), ("summaryLink", 3), ("asSummaryLink", 4), ("multicastLink", 6), ("nssaExternalLink", 7), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ospfAreaLsaCountLsaType.setDescription("This entry LSA type.")
ospfAreaLsaCountNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 14, 20, 1, 3), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ospfAreaLsaCountNumber.setDescription("Number of LSAs of a given type for a given area.")

# Augmentions

# Groups

ospfBasicGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 1)).setObjects(*(("OSPF-MIB", "ospfExternLsaCksumSum"), ("OSPF-MIB", "ospfASBdrRtrStatus"), ("OSPF-MIB", "ospfRxNewLsas"), ("OSPF-MIB", "ospfTOSSupport"), ("OSPF-MIB", "ospfExternLsaCount"), ("OSPF-MIB", "ospfExtLsdbLimit"), ("OSPF-MIB", "ospfAreaBdrRtrStatus"), ("OSPF-MIB", "ospfExitOverflowInterval"), ("OSPF-MIB", "ospfOriginateNewLsas"), ("OSPF-MIB", "ospfVersionNumber"), ("OSPF-MIB", "ospfDemandExtensions"), ("OSPF-MIB", "ospfAdminStat"), ("OSPF-MIB", "ospfMulticastExtensions"), ("OSPF-MIB", "ospfRouterId"), ) )
if mibBuilder.loadTexts: ospfBasicGroup.setDescription("These objects are used to monitor/manage\nglobal OSPF parameters.  This object group\nconforms to RFC 1850.")
ospfAreaGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 2)).setObjects(*(("OSPF-MIB", "ospfSpfRuns"), ("OSPF-MIB", "ospfAreaLsaCksumSum"), ("OSPF-MIB", "ospfAsBdrRtrCount"), ("OSPF-MIB", "ospfAreaId"), ("OSPF-MIB", "ospfImportAsExtern"), ("OSPF-MIB", "ospfAreaLsaCount"), ("OSPF-MIB", "ospfAreaBdrRtrCount"), ("OSPF-MIB", "ospfAreaSummary"), ("OSPF-MIB", "ospfAreaStatus"), ) )
if mibBuilder.loadTexts: ospfAreaGroup.setDescription("These objects are used for OSPF systems\nsupporting areas per RFC 1850.")
ospfStubAreaGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 3)).setObjects(*(("OSPF-MIB", "ospfStubMetricType"), ("OSPF-MIB", "ospfStubMetric"), ("OSPF-MIB", "ospfStubStatus"), ("OSPF-MIB", "ospfStubTOS"), ("OSPF-MIB", "ospfStubAreaId"), ) )
if mibBuilder.loadTexts: ospfStubAreaGroup.setDescription("These objects are used for OSPF systems\nsupporting stub areas.")
ospfLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 4)).setObjects(*(("OSPF-MIB", "ospfLsdbChecksum"), ("OSPF-MIB", "ospfLsdbRouterId"), ("OSPF-MIB", "ospfLsdbAge"), ("OSPF-MIB", "ospfLsdbAreaId"), ("OSPF-MIB", "ospfLsdbLsid"), ("OSPF-MIB", "ospfLsdbType"), ("OSPF-MIB", "ospfLsdbSequence"), ("OSPF-MIB", "ospfLsdbAdvertisement"), ) )
if mibBuilder.loadTexts: ospfLsdbGroup.setDescription("These objects are used for OSPF systems\nthat display their link state database.")
ospfAreaRangeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 5)).setObjects(*(("OSPF-MIB", "ospfAreaRangeAreaId"), ("OSPF-MIB", "ospfAreaRangeEffect"), ("OSPF-MIB", "ospfAreaRangeNet"), ("OSPF-MIB", "ospfAreaRangeStatus"), ("OSPF-MIB", "ospfAreaRangeMask"), ) )
if mibBuilder.loadTexts: ospfAreaRangeGroup.setDescription("These objects are used for non-CIDR OSPF\nsystems that support multiple areas.  This\nobject group is obsolete.")
ospfHostGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 6)).setObjects(*(("OSPF-MIB", "ospfHostAreaID"), ("OSPF-MIB", "ospfHostIpAddress"), ("OSPF-MIB", "ospfHostMetric"), ("OSPF-MIB", "ospfHostStatus"), ("OSPF-MIB", "ospfHostTOS"), ) )
if mibBuilder.loadTexts: ospfHostGroup.setDescription("These objects are used for OSPF systems\nthat support attached hosts.")
ospfIfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 7)).setObjects(*(("OSPF-MIB", "ospfIfPollInterval"), ("OSPF-MIB", "ospfIfEvents"), ("OSPF-MIB", "ospfIfAdminStat"), ("OSPF-MIB", "ospfIfStatus"), ("OSPF-MIB", "ospfIfIpAddress"), ("OSPF-MIB", "ospfIfRtrPriority"), ("OSPF-MIB", "ospfIfTransitDelay"), ("OSPF-MIB", "ospfIfState"), ("OSPF-MIB", "ospfIfAuthKey"), ("OSPF-MIB", "ospfIfDesignatedRouter"), ("OSPF-MIB", "ospfAddressLessIf"), ("OSPF-MIB", "ospfIfDemand"), ("OSPF-MIB", "ospfIfRtrDeadInterval"), ("OSPF-MIB", "ospfIfAuthType"), ("OSPF-MIB", "ospfIfBackupDesignatedRouter"), ("OSPF-MIB", "ospfIfType"), ("OSPF-MIB", "ospfIfAreaId"), ("OSPF-MIB", "ospfIfHelloInterval"), ("OSPF-MIB", "ospfIfRetransInterval"), ("OSPF-MIB", "ospfIfMulticastForwarding"), ) )
if mibBuilder.loadTexts: ospfIfGroup.setDescription("These objects are used to monitor/manage OSPF\ninterfaces.  This object group conforms to RFC 1850.")
ospfIfMetricGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 8)).setObjects(*(("OSPF-MIB", "ospfIfMetricAddressLessIf"), ("OSPF-MIB", "ospfIfMetricValue"), ("OSPF-MIB", "ospfIfMetricTOS"), ("OSPF-MIB", "ospfIfMetricIpAddress"), ("OSPF-MIB", "ospfIfMetricStatus"), ) )
if mibBuilder.loadTexts: ospfIfMetricGroup.setDescription("These objects are used for OSPF systems for supporting\n\n\n\ninterface metrics.")
ospfVirtIfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 9)).setObjects(*(("OSPF-MIB", "ospfVirtIfState"), ("OSPF-MIB", "ospfVirtIfRtrDeadInterval"), ("OSPF-MIB", "ospfVirtIfRetransInterval"), ("OSPF-MIB", "ospfVirtIfAuthKey"), ("OSPF-MIB", "ospfVirtIfTransitDelay"), ("OSPF-MIB", "ospfVirtIfEvents"), ("OSPF-MIB", "ospfVirtIfHelloInterval"), ("OSPF-MIB", "ospfVirtIfNeighbor"), ("OSPF-MIB", "ospfVirtIfStatus"), ("OSPF-MIB", "ospfVirtIfAreaId"), ("OSPF-MIB", "ospfVirtIfAuthType"), ) )
if mibBuilder.loadTexts: ospfVirtIfGroup.setDescription("These objects are used for OSPF systems for supporting\nvirtual interfaces.  This object group conforms\nto RFC 1850.")
ospfNbrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 10)).setObjects(*(("OSPF-MIB", "ospfNbrHelloSuppressed"), ("OSPF-MIB", "ospfNbrRtrId"), ("OSPF-MIB", "ospfNbrPriority"), ("OSPF-MIB", "ospfNbrLsRetransQLen"), ("OSPF-MIB", "ospfNbmaNbrPermanence"), ("OSPF-MIB", "ospfNbrOptions"), ("OSPF-MIB", "ospfNbrEvents"), ("OSPF-MIB", "ospfNbrState"), ("OSPF-MIB", "ospfNbmaNbrStatus"), ("OSPF-MIB", "ospfNbrAddressLessIndex"), ("OSPF-MIB", "ospfNbrIpAddr"), ) )
if mibBuilder.loadTexts: ospfNbrGroup.setDescription("These objects are used to monitor/manage OSPF neighbors.\nThis object group conforms to RFC 1850.")
ospfVirtNbrGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 11)).setObjects(*(("OSPF-MIB", "ospfVirtNbrRtrId"), ("OSPF-MIB", "ospfVirtNbrIpAddr"), ("OSPF-MIB", "ospfVirtNbrEvents"), ("OSPF-MIB", "ospfVirtNbrArea"), ("OSPF-MIB", "ospfVirtNbrHelloSuppressed"), ("OSPF-MIB", "ospfVirtNbrLsRetransQLen"), ("OSPF-MIB", "ospfVirtNbrState"), ("OSPF-MIB", "ospfVirtNbrOptions"), ) )
if mibBuilder.loadTexts: ospfVirtNbrGroup.setDescription("These objects are used to monitor/manage OSPF virtual\nneighbors.  This object group conforms to RFC 1850.")
ospfExtLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 12)).setObjects(*(("OSPF-MIB", "ospfExtLsdbChecksum"), ("OSPF-MIB", "ospfExtLsdbType"), ("OSPF-MIB", "ospfExtLsdbSequence"), ("OSPF-MIB", "ospfExtLsdbAdvertisement"), ("OSPF-MIB", "ospfExtLsdbAge"), ("OSPF-MIB", "ospfExtLsdbRouterId"), ("OSPF-MIB", "ospfExtLsdbLsid"), ) )
if mibBuilder.loadTexts: ospfExtLsdbGroup.setDescription("These objects are used for OSPF systems that display\ntheir link state database.  This object group\nconforms to RFC 1850.\n\nThis object group is replaced by the ospfAsLsdbGroup\nin order to support any AS-scope LSA type in a single\ntable.")
ospfAreaAggregateGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 13)).setObjects(*(("OSPF-MIB", "ospfAreaAggregateLsdbType"), ("OSPF-MIB", "ospfAreaAggregateStatus"), ("OSPF-MIB", "ospfAreaAggregateAreaID"), ("OSPF-MIB", "ospfAreaAggregateEffect"), ("OSPF-MIB", "ospfAreaAggregateMask"), ("OSPF-MIB", "ospfAreaAggregateNet"), ) )
if mibBuilder.loadTexts: ospfAreaAggregateGroup.setDescription("These objects are used for OSPF systems to support\nnetwork prefix aggregation across areas.")
ospfLocalLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 14)).setObjects(*(("OSPF-MIB", "ospfLocalLsdbAge"), ("OSPF-MIB", "ospfLocalLsdbSequence"), ("OSPF-MIB", "ospfLocalLsdbChecksum"), ("OSPF-MIB", "ospfLocalLsdbAdvertisement"), ) )
if mibBuilder.loadTexts: ospfLocalLsdbGroup.setDescription("These objects are used for OSPF systems\nthat display their link-local link state databases\nfor non-virtual links.")
ospfVirtLocalLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 15)).setObjects(*(("OSPF-MIB", "ospfVirtLocalLsdbAdvertisement"), ("OSPF-MIB", "ospfVirtLocalLsdbChecksum"), ("OSPF-MIB", "ospfVirtLocalLsdbAge"), ("OSPF-MIB", "ospfVirtLocalLsdbSequence"), ) )
if mibBuilder.loadTexts: ospfVirtLocalLsdbGroup.setDescription("These objects are used for OSPF systems\nthat display their link-local link state databases\nfor virtual links.")
ospfAsLsdbGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 16)).setObjects(*(("OSPF-MIB", "ospfAsLsdbChecksum"), ("OSPF-MIB", "ospfAsLsdbAge"), ("OSPF-MIB", "ospfAsLsdbSequence"), ("OSPF-MIB", "ospfAsLsdbAdvertisement"), ) )
if mibBuilder.loadTexts: ospfAsLsdbGroup.setDescription("These objects are used for OSPF systems\nthat display their AS-scope link state database.")
ospfBasicGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 17)).setObjects(*(("OSPF-MIB", "ospfReferenceBandwidth"), ("OSPF-MIB", "ospfRxNewLsas"), ("OSPF-MIB", "ospfRestartExitReason"), ("OSPF-MIB", "ospfExternLsaCount"), ("OSPF-MIB", "ospfExitOverflowInterval"), ("OSPF-MIB", "ospfOriginateNewLsas"), ("OSPF-MIB", "ospfAsLsaCount"), ("OSPF-MIB", "ospfStubRouterSupport"), ("OSPF-MIB", "ospfDemandExtensions"), ("OSPF-MIB", "ospfAsLsaCksumSum"), ("OSPF-MIB", "ospfMulticastExtensions"), ("OSPF-MIB", "ospfExternLsaCksumSum"), ("OSPF-MIB", "ospfASBdrRtrStatus"), ("OSPF-MIB", "ospfRestartStatus"), ("OSPF-MIB", "ospfTOSSupport"), ("OSPF-MIB", "ospfRFC1583Compatibility"), ("OSPF-MIB", "ospfRestartInterval"), ("OSPF-MIB", "ospfExtLsdbLimit"), ("OSPF-MIB", "ospfAreaBdrRtrStatus"), ("OSPF-MIB", "ospfRestartStrictLsaChecking"), ("OSPF-MIB", "ospfStubRouterAdvertisement"), ("OSPF-MIB", "ospfVersionNumber"), ("OSPF-MIB", "ospfRestartAge"), ("OSPF-MIB", "ospfDiscontinuityTime"), ("OSPF-MIB", "ospfOpaqueLsaSupport"), ("OSPF-MIB", "ospfRestartSupport"), ("OSPF-MIB", "ospfAdminStat"), ("OSPF-MIB", "ospfRouterId"), ) )
if mibBuilder.loadTexts: ospfBasicGroup2.setDescription("These objects are used to monitor/manage OSPF global\nparameters.")
ospfAreaGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 18)).setObjects(*(("OSPF-MIB", "ospfSpfRuns"), ("OSPF-MIB", "ospfAsBdrRtrCount"), ("OSPF-MIB", "ospfAreaNssaTranslatorRole"), ("OSPF-MIB", "ospfAreaSummary"), ("OSPF-MIB", "ospfAreaNssaTranslatorState"), ("OSPF-MIB", "ospfAreaId"), ("OSPF-MIB", "ospfAreaLsaCount"), ("OSPF-MIB", "ospfAreaStatus"), ("OSPF-MIB", "ospfAreaLsaCksumSum"), ("OSPF-MIB", "ospfImportAsExtern"), ("OSPF-MIB", "ospfAreaNssaTranslatorStabilityInterval"), ("OSPF-MIB", "ospfAreaBdrRtrCount"), ("OSPF-MIB", "ospfAreaNssaTranslatorEvents"), ) )
if mibBuilder.loadTexts: ospfAreaGroup2.setDescription("These objects are used by OSPF systems\nto support areas.")
ospfIfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 19)).setObjects(*(("OSPF-MIB", "ospfIfStatus"), ("OSPF-MIB", "ospfIfDemand"), ("OSPF-MIB", "ospfIfPollInterval"), ("OSPF-MIB", "ospfIfAreaId"), ("OSPF-MIB", "ospfIfLsaCount"), ("OSPF-MIB", "ospfIfEvents"), ("OSPF-MIB", "ospfIfRtrDeadInterval"), ("OSPF-MIB", "ospfIfRtrPriority"), ("OSPF-MIB", "ospfAddressLessIf"), ("OSPF-MIB", "ospfIfAuthType"), ("OSPF-MIB", "ospfIfDesignatedRouter"), ("OSPF-MIB", "ospfIfLsaCksumSum"), ("OSPF-MIB", "ospfIfState"), ("OSPF-MIB", "ospfIfBackupDesignatedRouter"), ("OSPF-MIB", "ospfIfHelloInterval"), ("OSPF-MIB", "ospfIfRetransInterval"), ("OSPF-MIB", "ospfIfMulticastForwarding"), ("OSPF-MIB", "ospfIfAdminStat"), ("OSPF-MIB", "ospfIfIpAddress"), ("OSPF-MIB", "ospfIfTransitDelay"), ("OSPF-MIB", "ospfIfAuthKey"), ("OSPF-MIB", "ospfIfType"), ) )
if mibBuilder.loadTexts: ospfIfGroup2.setDescription("These objects are used to monitor/manage OSPF interfaces.")
ospfVirtIfGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 20)).setObjects(*(("OSPF-MIB", "ospfVirtIfState"), ("OSPF-MIB", "ospfVirtIfLsaCksumSum"), ("OSPF-MIB", "ospfVirtIfRtrDeadInterval"), ("OSPF-MIB", "ospfVirtIfRetransInterval"), ("OSPF-MIB", "ospfVirtIfAuthKey"), ("OSPF-MIB", "ospfVirtIfLsaCount"), ("OSPF-MIB", "ospfVirtIfTransitDelay"), ("OSPF-MIB", "ospfVirtIfEvents"), ("OSPF-MIB", "ospfVirtIfHelloInterval"), ("OSPF-MIB", "ospfVirtIfNeighbor"), ("OSPF-MIB", "ospfVirtIfStatus"), ("OSPF-MIB", "ospfIfDesignatedRouterId"), ("OSPF-MIB", "ospfVirtIfAreaId"), ("OSPF-MIB", "ospfVirtIfAuthType"), ("OSPF-MIB", "ospfIfBackupDesignatedRouterId"), ) )
if mibBuilder.loadTexts: ospfVirtIfGroup2.setDescription("These objects are used to monitor/manage OSPF\nvirtual interfaces.")
ospfNbrGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 21)).setObjects(*(("OSPF-MIB", "ospfNbrHelloSuppressed"), ("OSPF-MIB", "ospfNbrRestartHelperExitReason"), ("OSPF-MIB", "ospfNbrRtrId"), ("OSPF-MIB", "ospfNbrPriority"), ("OSPF-MIB", "ospfNbrLsRetransQLen"), ("OSPF-MIB", "ospfNbmaNbrPermanence"), ("OSPF-MIB", "ospfNbrRestartHelperAge"), ("OSPF-MIB", "ospfNbrRestartHelperStatus"), ("OSPF-MIB", "ospfNbrOptions"), ("OSPF-MIB", "ospfNbrEvents"), ("OSPF-MIB", "ospfNbrState"), ("OSPF-MIB", "ospfNbmaNbrStatus"), ("OSPF-MIB", "ospfNbrAddressLessIndex"), ("OSPF-MIB", "ospfNbrIpAddr"), ) )
if mibBuilder.loadTexts: ospfNbrGroup2.setDescription("These objects are used to monitor/manage OSPF\nneighbors.")
ospfVirtNbrGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 22)).setObjects(*(("OSPF-MIB", "ospfVirtNbrIpAddr"), ("OSPF-MIB", "ospfVirtNbrEvents"), ("OSPF-MIB", "ospfVirtNbrState"), ("OSPF-MIB", "ospfVirtNbrLsRetransQLen"), ("OSPF-MIB", "ospfVirtNbrRestartHelperAge"), ("OSPF-MIB", "ospfVirtNbrRestartHelperExitReason"), ("OSPF-MIB", "ospfVirtNbrOptions"), ("OSPF-MIB", "ospfVirtNbrRtrId"), ("OSPF-MIB", "ospfVirtNbrArea"), ("OSPF-MIB", "ospfVirtNbrHelloSuppressed"), ("OSPF-MIB", "ospfVirtNbrRestartHelperStatus"), ) )
if mibBuilder.loadTexts: ospfVirtNbrGroup2.setDescription("These objects are used to monitor/manage OSPF\nvirtual neighbors.")
ospfAreaAggregateGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 23)).setObjects(*(("OSPF-MIB", "ospfAreaAggregateExtRouteTag"), ("OSPF-MIB", "ospfAreaAggregateLsdbType"), ("OSPF-MIB", "ospfAreaAggregateStatus"), ("OSPF-MIB", "ospfAreaAggregateAreaID"), ("OSPF-MIB", "ospfAreaAggregateEffect"), ("OSPF-MIB", "ospfAreaAggregateMask"), ("OSPF-MIB", "ospfAreaAggregateNet"), ) )
if mibBuilder.loadTexts: ospfAreaAggregateGroup2.setDescription("These objects are used for OSPF systems to support\nnetwork prefix aggregation across areas.")
ospfAreaLsaCountGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 24)).setObjects(*(("OSPF-MIB", "ospfAreaLsaCountNumber"), ) )
if mibBuilder.loadTexts: ospfAreaLsaCountGroup.setDescription("These objects are used for OSPF systems that display\nper-area, per-LSA-type counters.")
ospfHostGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 25)).setObjects(*(("OSPF-MIB", "ospfHostIpAddress"), ("OSPF-MIB", "ospfHostCfgAreaID"), ("OSPF-MIB", "ospfHostMetric"), ("OSPF-MIB", "ospfHostStatus"), ("OSPF-MIB", "ospfHostTOS"), ) )
if mibBuilder.loadTexts: ospfHostGroup2.setDescription("These objects are used for OSPF systems\nthat support attached hosts.")
ospfObsoleteGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 14, 15, 1, 26)).setObjects(*(("OSPF-MIB", "ospfAuthType"), ) )
if mibBuilder.loadTexts: ospfObsoleteGroup.setDescription("These objects are obsolete and are no longer required for\nOSPF systems.  They are placed into this group for SMI\nconformance.")

# Compliances

ospfCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 14, 15, 2, 1)).setObjects(*(("OSPF-MIB", "ospfStubAreaGroup"), ("OSPF-MIB", "ospfIfMetricGroup"), ("OSPF-MIB", "ospfAreaAggregateGroup"), ("OSPF-MIB", "ospfBasicGroup"), ("OSPF-MIB", "ospfVirtIfGroup"), ("OSPF-MIB", "ospfLsdbGroup"), ("OSPF-MIB", "ospfVirtNbrGroup"), ("OSPF-MIB", "ospfExtLsdbGroup"), ("OSPF-MIB", "ospfAreaGroup"), ("OSPF-MIB", "ospfIfGroup"), ("OSPF-MIB", "ospfHostGroup"), ("OSPF-MIB", "ospfNbrGroup"), ) )
if mibBuilder.loadTexts: ospfCompliance.setDescription("The compliance statement for OSPF systems\nconforming to RFC 1850.")
ospfCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 14, 15, 2, 2)).setObjects(*(("OSPF-MIB", "ospfHostGroup2"), ("OSPF-MIB", "ospfAreaGroup2"), ("OSPF-MIB", "ospfStubAreaGroup"), ("OSPF-MIB", "ospfVirtLocalLsdbGroup"), ("OSPF-MIB", "ospfVirtNbrGroup2"), ("OSPF-MIB", "ospfIfMetricGroup"), ("OSPF-MIB", "ospfIfGroup2"), ("OSPF-MIB", "ospfLsdbGroup"), ("OSPF-MIB", "ospfVirtIfGroup2"), ("OSPF-MIB", "ospfAreaLsaCountGroup"), ("OSPF-MIB", "ospfNbrGroup2"), ("OSPF-MIB", "ospfAreaAggregateGroup2"), ("OSPF-MIB", "ospfBasicGroup2"), ("OSPF-MIB", "ospfAsLsdbGroup"), ("OSPF-MIB", "ospfLocalLsdbGroup"), ) )
if mibBuilder.loadTexts: ospfCompliance2.setDescription("The compliance statement.")
ospfComplianceObsolete = ModuleCompliance((1, 3, 6, 1, 2, 1, 14, 15, 2, 3)).setObjects(*(("OSPF-MIB", "ospfAreaRangeGroup"), ("OSPF-MIB", "ospfObsoleteGroup"), ) )
if mibBuilder.loadTexts: ospfComplianceObsolete.setDescription("Contains obsolete object groups.")

# Exports

# Module identity
mibBuilder.exportSymbols("OSPF-MIB", PYSNMP_MODULE_ID=ospf)

# Types
mibBuilder.exportSymbols("OSPF-MIB", BigMetric=BigMetric, DesignatedRouterPriority=DesignatedRouterPriority, HelloRange=HelloRange, Metric=Metric, OspfAuthenticationType=OspfAuthenticationType, PositiveInteger=PositiveInteger, Status=Status, TOSType=TOSType, UpToMaxAge=UpToMaxAge, AreaID=AreaID, RouterID=RouterID)

# Objects
mibBuilder.exportSymbols("OSPF-MIB", ospf=ospf, ospfGeneralGroup=ospfGeneralGroup, ospfRouterId=ospfRouterId, ospfAdminStat=ospfAdminStat, ospfVersionNumber=ospfVersionNumber, ospfAreaBdrRtrStatus=ospfAreaBdrRtrStatus, ospfASBdrRtrStatus=ospfASBdrRtrStatus, ospfExternLsaCount=ospfExternLsaCount, ospfExternLsaCksumSum=ospfExternLsaCksumSum, ospfTOSSupport=ospfTOSSupport, ospfOriginateNewLsas=ospfOriginateNewLsas, ospfRxNewLsas=ospfRxNewLsas, ospfExtLsdbLimit=ospfExtLsdbLimit, ospfMulticastExtensions=ospfMulticastExtensions, ospfExitOverflowInterval=ospfExitOverflowInterval, ospfDemandExtensions=ospfDemandExtensions, ospfRFC1583Compatibility=ospfRFC1583Compatibility, ospfOpaqueLsaSupport=ospfOpaqueLsaSupport, ospfReferenceBandwidth=ospfReferenceBandwidth, ospfRestartSupport=ospfRestartSupport, ospfRestartInterval=ospfRestartInterval, ospfRestartStrictLsaChecking=ospfRestartStrictLsaChecking, ospfRestartStatus=ospfRestartStatus, ospfRestartAge=ospfRestartAge, ospfRestartExitReason=ospfRestartExitReason, ospfAsLsaCount=ospfAsLsaCount, ospfAsLsaCksumSum=ospfAsLsaCksumSum, ospfStubRouterSupport=ospfStubRouterSupport, ospfStubRouterAdvertisement=ospfStubRouterAdvertisement, ospfDiscontinuityTime=ospfDiscontinuityTime, ospfAreaTable=ospfAreaTable, ospfAreaEntry=ospfAreaEntry, ospfAreaId=ospfAreaId, ospfAuthType=ospfAuthType, ospfImportAsExtern=ospfImportAsExtern, ospfSpfRuns=ospfSpfRuns, ospfAreaBdrRtrCount=ospfAreaBdrRtrCount, ospfAsBdrRtrCount=ospfAsBdrRtrCount, ospfAreaLsaCount=ospfAreaLsaCount, ospfAreaLsaCksumSum=ospfAreaLsaCksumSum, ospfAreaSummary=ospfAreaSummary, ospfAreaStatus=ospfAreaStatus, ospfAreaNssaTranslatorRole=ospfAreaNssaTranslatorRole, ospfAreaNssaTranslatorState=ospfAreaNssaTranslatorState, ospfAreaNssaTranslatorStabilityInterval=ospfAreaNssaTranslatorStabilityInterval, ospfAreaNssaTranslatorEvents=ospfAreaNssaTranslatorEvents, ospfStubAreaTable=ospfStubAreaTable, ospfStubAreaEntry=ospfStubAreaEntry, ospfStubAreaId=ospfStubAreaId, ospfStubTOS=ospfStubTOS, ospfStubMetric=ospfStubMetric, ospfStubStatus=ospfStubStatus, ospfStubMetricType=ospfStubMetricType, ospfLsdbTable=ospfLsdbTable, ospfLsdbEntry=ospfLsdbEntry, ospfLsdbAreaId=ospfLsdbAreaId, ospfLsdbType=ospfLsdbType, ospfLsdbLsid=ospfLsdbLsid, ospfLsdbRouterId=ospfLsdbRouterId, ospfLsdbSequence=ospfLsdbSequence, ospfLsdbAge=ospfLsdbAge, ospfLsdbChecksum=ospfLsdbChecksum, ospfLsdbAdvertisement=ospfLsdbAdvertisement, ospfAreaRangeTable=ospfAreaRangeTable, ospfAreaRangeEntry=ospfAreaRangeEntry, ospfAreaRangeAreaId=ospfAreaRangeAreaId, ospfAreaRangeNet=ospfAreaRangeNet, ospfAreaRangeMask=ospfAreaRangeMask, ospfAreaRangeStatus=ospfAreaRangeStatus, ospfAreaRangeEffect=ospfAreaRangeEffect, ospfHostTable=ospfHostTable, ospfHostEntry=ospfHostEntry, ospfHostIpAddress=ospfHostIpAddress, ospfHostTOS=ospfHostTOS, ospfHostMetric=ospfHostMetric, ospfHostStatus=ospfHostStatus, ospfHostAreaID=ospfHostAreaID, ospfHostCfgAreaID=ospfHostCfgAreaID, ospfIfTable=ospfIfTable, ospfIfEntry=ospfIfEntry, ospfIfIpAddress=ospfIfIpAddress, ospfAddressLessIf=ospfAddressLessIf, ospfIfAreaId=ospfIfAreaId, ospfIfType=ospfIfType, ospfIfAdminStat=ospfIfAdminStat, ospfIfRtrPriority=ospfIfRtrPriority, ospfIfTransitDelay=ospfIfTransitDelay, ospfIfRetransInterval=ospfIfRetransInterval, ospfIfHelloInterval=ospfIfHelloInterval, ospfIfRtrDeadInterval=ospfIfRtrDeadInterval, ospfIfPollInterval=ospfIfPollInterval, ospfIfState=ospfIfState, ospfIfDesignatedRouter=ospfIfDesignatedRouter, ospfIfBackupDesignatedRouter=ospfIfBackupDesignatedRouter, ospfIfEvents=ospfIfEvents, ospfIfAuthKey=ospfIfAuthKey, ospfIfStatus=ospfIfStatus, ospfIfMulticastForwarding=ospfIfMulticastForwarding, ospfIfDemand=ospfIfDemand, ospfIfAuthType=ospfIfAuthType, ospfIfLsaCount=ospfIfLsaCount, ospfIfLsaCksumSum=ospfIfLsaCksumSum, ospfIfDesignatedRouterId=ospfIfDesignatedRouterId, ospfIfBackupDesignatedRouterId=ospfIfBackupDesignatedRouterId, ospfIfMetricTable=ospfIfMetricTable, ospfIfMetricEntry=ospfIfMetricEntry, ospfIfMetricIpAddress=ospfIfMetricIpAddress, ospfIfMetricAddressLessIf=ospfIfMetricAddressLessIf, ospfIfMetricTOS=ospfIfMetricTOS, ospfIfMetricValue=ospfIfMetricValue, ospfIfMetricStatus=ospfIfMetricStatus, ospfVirtIfTable=ospfVirtIfTable, ospfVirtIfEntry=ospfVirtIfEntry, ospfVirtIfAreaId=ospfVirtIfAreaId, ospfVirtIfNeighbor=ospfVirtIfNeighbor, ospfVirtIfTransitDelay=ospfVirtIfTransitDelay, ospfVirtIfRetransInterval=ospfVirtIfRetransInterval, ospfVirtIfHelloInterval=ospfVirtIfHelloInterval, ospfVirtIfRtrDeadInterval=ospfVirtIfRtrDeadInterval, ospfVirtIfState=ospfVirtIfState, ospfVirtIfEvents=ospfVirtIfEvents, ospfVirtIfAuthKey=ospfVirtIfAuthKey, ospfVirtIfStatus=ospfVirtIfStatus, ospfVirtIfAuthType=ospfVirtIfAuthType, ospfVirtIfLsaCount=ospfVirtIfLsaCount, ospfVirtIfLsaCksumSum=ospfVirtIfLsaCksumSum)
mibBuilder.exportSymbols("OSPF-MIB", ospfNbrTable=ospfNbrTable, ospfNbrEntry=ospfNbrEntry, ospfNbrIpAddr=ospfNbrIpAddr, ospfNbrAddressLessIndex=ospfNbrAddressLessIndex, ospfNbrRtrId=ospfNbrRtrId, ospfNbrOptions=ospfNbrOptions, ospfNbrPriority=ospfNbrPriority, ospfNbrState=ospfNbrState, ospfNbrEvents=ospfNbrEvents, ospfNbrLsRetransQLen=ospfNbrLsRetransQLen, ospfNbmaNbrStatus=ospfNbmaNbrStatus, ospfNbmaNbrPermanence=ospfNbmaNbrPermanence, ospfNbrHelloSuppressed=ospfNbrHelloSuppressed, ospfNbrRestartHelperStatus=ospfNbrRestartHelperStatus, ospfNbrRestartHelperAge=ospfNbrRestartHelperAge, ospfNbrRestartHelperExitReason=ospfNbrRestartHelperExitReason, ospfVirtNbrTable=ospfVirtNbrTable, ospfVirtNbrEntry=ospfVirtNbrEntry, ospfVirtNbrArea=ospfVirtNbrArea, ospfVirtNbrRtrId=ospfVirtNbrRtrId, ospfVirtNbrIpAddr=ospfVirtNbrIpAddr, ospfVirtNbrOptions=ospfVirtNbrOptions, ospfVirtNbrState=ospfVirtNbrState, ospfVirtNbrEvents=ospfVirtNbrEvents, ospfVirtNbrLsRetransQLen=ospfVirtNbrLsRetransQLen, ospfVirtNbrHelloSuppressed=ospfVirtNbrHelloSuppressed, ospfVirtNbrRestartHelperStatus=ospfVirtNbrRestartHelperStatus, ospfVirtNbrRestartHelperAge=ospfVirtNbrRestartHelperAge, ospfVirtNbrRestartHelperExitReason=ospfVirtNbrRestartHelperExitReason, ospfExtLsdbTable=ospfExtLsdbTable, ospfExtLsdbEntry=ospfExtLsdbEntry, ospfExtLsdbType=ospfExtLsdbType, ospfExtLsdbLsid=ospfExtLsdbLsid, ospfExtLsdbRouterId=ospfExtLsdbRouterId, ospfExtLsdbSequence=ospfExtLsdbSequence, ospfExtLsdbAge=ospfExtLsdbAge, ospfExtLsdbChecksum=ospfExtLsdbChecksum, ospfExtLsdbAdvertisement=ospfExtLsdbAdvertisement, ospfRouteGroup=ospfRouteGroup, ospfIntraArea=ospfIntraArea, ospfInterArea=ospfInterArea, ospfExternalType1=ospfExternalType1, ospfExternalType2=ospfExternalType2, ospfAreaAggregateTable=ospfAreaAggregateTable, ospfAreaAggregateEntry=ospfAreaAggregateEntry, ospfAreaAggregateAreaID=ospfAreaAggregateAreaID, ospfAreaAggregateLsdbType=ospfAreaAggregateLsdbType, ospfAreaAggregateNet=ospfAreaAggregateNet, ospfAreaAggregateMask=ospfAreaAggregateMask, ospfAreaAggregateStatus=ospfAreaAggregateStatus, ospfAreaAggregateEffect=ospfAreaAggregateEffect, ospfAreaAggregateExtRouteTag=ospfAreaAggregateExtRouteTag, ospfConformance=ospfConformance, ospfGroups=ospfGroups, ospfCompliances=ospfCompliances, ospfLocalLsdbTable=ospfLocalLsdbTable, ospfLocalLsdbEntry=ospfLocalLsdbEntry, ospfLocalLsdbIpAddress=ospfLocalLsdbIpAddress, ospfLocalLsdbAddressLessIf=ospfLocalLsdbAddressLessIf, ospfLocalLsdbType=ospfLocalLsdbType, ospfLocalLsdbLsid=ospfLocalLsdbLsid, ospfLocalLsdbRouterId=ospfLocalLsdbRouterId, ospfLocalLsdbSequence=ospfLocalLsdbSequence, ospfLocalLsdbAge=ospfLocalLsdbAge, ospfLocalLsdbChecksum=ospfLocalLsdbChecksum, ospfLocalLsdbAdvertisement=ospfLocalLsdbAdvertisement, ospfVirtLocalLsdbTable=ospfVirtLocalLsdbTable, ospfVirtLocalLsdbEntry=ospfVirtLocalLsdbEntry, ospfVirtLocalLsdbTransitArea=ospfVirtLocalLsdbTransitArea, ospfVirtLocalLsdbNeighbor=ospfVirtLocalLsdbNeighbor, ospfVirtLocalLsdbType=ospfVirtLocalLsdbType, ospfVirtLocalLsdbLsid=ospfVirtLocalLsdbLsid, ospfVirtLocalLsdbRouterId=ospfVirtLocalLsdbRouterId, ospfVirtLocalLsdbSequence=ospfVirtLocalLsdbSequence, ospfVirtLocalLsdbAge=ospfVirtLocalLsdbAge, ospfVirtLocalLsdbChecksum=ospfVirtLocalLsdbChecksum, ospfVirtLocalLsdbAdvertisement=ospfVirtLocalLsdbAdvertisement, ospfAsLsdbTable=ospfAsLsdbTable, ospfAsLsdbEntry=ospfAsLsdbEntry, ospfAsLsdbType=ospfAsLsdbType, ospfAsLsdbLsid=ospfAsLsdbLsid, ospfAsLsdbRouterId=ospfAsLsdbRouterId, ospfAsLsdbSequence=ospfAsLsdbSequence, ospfAsLsdbAge=ospfAsLsdbAge, ospfAsLsdbChecksum=ospfAsLsdbChecksum, ospfAsLsdbAdvertisement=ospfAsLsdbAdvertisement, ospfAreaLsaCountTable=ospfAreaLsaCountTable, ospfAreaLsaCountEntry=ospfAreaLsaCountEntry, ospfAreaLsaCountAreaId=ospfAreaLsaCountAreaId, ospfAreaLsaCountLsaType=ospfAreaLsaCountLsaType, ospfAreaLsaCountNumber=ospfAreaLsaCountNumber)

# Groups
mibBuilder.exportSymbols("OSPF-MIB", ospfBasicGroup=ospfBasicGroup, ospfAreaGroup=ospfAreaGroup, ospfStubAreaGroup=ospfStubAreaGroup, ospfLsdbGroup=ospfLsdbGroup, ospfAreaRangeGroup=ospfAreaRangeGroup, ospfHostGroup=ospfHostGroup, ospfIfGroup=ospfIfGroup, ospfIfMetricGroup=ospfIfMetricGroup, ospfVirtIfGroup=ospfVirtIfGroup, ospfNbrGroup=ospfNbrGroup, ospfVirtNbrGroup=ospfVirtNbrGroup, ospfExtLsdbGroup=ospfExtLsdbGroup, ospfAreaAggregateGroup=ospfAreaAggregateGroup, ospfLocalLsdbGroup=ospfLocalLsdbGroup, ospfVirtLocalLsdbGroup=ospfVirtLocalLsdbGroup, ospfAsLsdbGroup=ospfAsLsdbGroup, ospfBasicGroup2=ospfBasicGroup2, ospfAreaGroup2=ospfAreaGroup2, ospfIfGroup2=ospfIfGroup2, ospfVirtIfGroup2=ospfVirtIfGroup2, ospfNbrGroup2=ospfNbrGroup2, ospfVirtNbrGroup2=ospfVirtNbrGroup2, ospfAreaAggregateGroup2=ospfAreaAggregateGroup2, ospfAreaLsaCountGroup=ospfAreaLsaCountGroup, ospfHostGroup2=ospfHostGroup2, ospfObsoleteGroup=ospfObsoleteGroup)

# Compliances
mibBuilder.exportSymbols("OSPF-MIB", ospfCompliance=ospfCompliance, ospfCompliance2=ospfCompliance2, ospfComplianceObsolete=ospfComplianceObsolete)
