"""
create users, currently only in chroot
"""

import os
from command_runner import command_runner

def add_users(users, chroot):
    """
    Add one or more users to the system.
    """
    for user in users:
        password_hash = os.popen("mkpasswd --method=SHA-512 " + user['password']).read().replace('\n', '')
        ecode, result = command_runner("chroot %s useradd -p '%s' %s" % (chroot, password_hash, user['username']))
        ecode, result = command_runner("chroot %s mkdir home/%s" % (chroot, user['username']))
        ecode, result = command_runner("chroot %s chown %s home/%s" % (chroot, user['username'], user['username']))
        if user['sudo']:
            ecode, result = command_runner("chroot %s adduser %s sudo" % (chroot, user['username']))
            ecode, result = command_runner("chroot %s apt-get install sudo" % chroot)

