% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colIQRs.R, R/rowIQRs.R
\name{colIQRs,DelayedMatrix-method}
\alias{colIQRs,DelayedMatrix-method}
\alias{rowIQRs,DelayedMatrix-method}
\title{Calculates the interquartile range for each row (column) of a matrix-like
object}
\usage{
\S4method{colIQRs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...
)

\S4method{rowIQRs}{DelayedMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  force_block_processing = FALSE,
  ...
)
}
\arguments{
\item{x}{A NxK \linkS4class{DelayedMatrix}.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, \code{\link{NA}}s
are excluded first, otherwise not.}

\item{force_block_processing}{\code{FALSE} (the default) means that a
seed-aware, optimised method is used (if available). This can be overridden
to use the general block-processing strategy by setting this to \code{TRUE}
(typically not advised). The block-processing strategy loads one or more
(depending on \verb{\link[DelayedArray]\{getAutoBlockSize\}()}) columns (\code{colFoo()})
or rows (\code{rowFoo()}) into memory as an ordinary \link[base:array]{base::array}.}

\item{...}{Additional arguments passed to specific methods.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the interquartile range for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowIQRs}
/ \code{matrixStats::colIQRs}.
}
\examples{
# A DelayedMatrix with a 'matrix' seed
dm_matrix <- DelayedArray(matrix(c(rep(1L, 5),
                                   as.integer((0:4) ^ 2),
                                   seq(-5L, -1L, 1L)),
                                 ncol = 3))
# A DelayedMatrix with a 'Matrix' seed
dm_Matrix <- DelayedArray(Matrix::Matrix(c(rep(1L, 5),
                                           as.integer((0:4) ^ 2),
                                           seq(-5L, -1L, 1L)),
                                         ncol = 3))

colIQRs(dm_matrix)

# Only using rows 2-4
rowIQRs(dm_matrix, rows = 2:4)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowIQRs}()} and
\code{matrixStats::\link[matrixStats:rowIQRs]{colIQRs}()} which are used
when the input is a \code{matrix} or \code{numeric} vector.
\item For a non-robust analog, see \code{\link[MatrixGenerics]{rowSds}()}. For a more
robust version see \code{\link[MatrixGenerics:rowMads]{rowMads()}}
\item \code{stats::\link[stats]{IQR}()}.
}
}
\author{
Peter Hickey
}
