ORGANISM <- "Betacoronavirus"  # genus only (no subgenus)

ASSEMBLIES <- list(
    ## Assembly for "SARS-CoV" virus (a.k.a. "Severe acute respiratory
    ## syndrome-related coronavirus", "SARSr-CoV", "SARSrCoV", "Human
    ## coronavirus (strain SARS)", "SARS coronavirus", "HCoV-SARS", "SARS",
    ## "SARS virus"):
    ##   https://www.ncbi.nlm.nih.gov/genomes/SARS/SARS.html
    list(assembly="ViralProj15500",
         date="2003/04/14",
         extra_info=c(subgenus="Sarbecovirus", name="SARS-CoV"),
         assembly_accession="GCA_000864885.1",
         circ_seqs=character(0)),

    ## All assemblies for "Wuhan seafood market pneumonia virus" (a.k.a.
    ## "Wuhan coronavirus" or "2019-nCoV", Taxonomy ID: 2697049) listed at
    ##   https://www.ncbi.nlm.nih.gov/assembly/organism/2697049/
    ## as of Feb 5, 2020, and ordered by assembly name (i.e. by "genome"
    ## field):
    list(assembly="ASM985889v1",
         date="2020/01/13",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009858895.1",
         circ_seqs=character(0)),

    list(assembly="ASM985889v2",
         date="2020/01/12",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009858895.2",
         circ_seqs=character(0)),

    list(assembly="ASM985889v3",
         date="2020/01/13",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009858895.3",
         circ_seqs=character(0)),

    list(assembly="ASM993788v1",
         date="2020/01/24",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009937885.1",
         circ_seqs=character(0)),

    list(assembly="ASM993789v1",
         date="2020/01/24",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009937895.1",
         circ_seqs=character(0)),

    list(assembly="ASM993790v1",
         date="2020/01/24",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009937905.1",
         circ_seqs=character(0)),

    list(assembly="ASM993791v1",
         date="2020/01/25",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009937915.1",
         circ_seqs=character(0)),

    list(assembly="ASM993792v1",
         date="2020/01/28",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009937925.1",
         circ_seqs=character(0)),

    list(assembly="ASM993793v1",
         date="2020/01/28",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009937935.1",
         circ_seqs=character(0)),

    list(assembly="ASM993794v1",
         date="2020/01/28",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009937945.1",
         circ_seqs=character(0)),

    list(assembly="ASM993805v1",
         date="2020/01/28",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009938055.1",
         circ_seqs=character(0)),

    list(assembly="ASM993806v1",
         date="2020/01/28",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009938065.1",
         circ_seqs=character(0)),

    list(assembly="ASM994842v1",
         date="2020/01/29",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009948425.1",
         circ_seqs=character(0)),

    list(assembly="ASM994846v1",
         date="2020/01/29",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009948465.1",
         circ_seqs=character(0)),

    list(assembly="ASM994849v1",
         date="2020/01/29",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009948495.1",
         circ_seqs=character(0)),

    list(assembly="ASM994852v1",
         date="2020/01/29",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009948525.1",
         circ_seqs=character(0)),

    list(assembly="ASM994855v1",
         date="2020/01/29",
         extra_info=c(subgenus="Sarbecovirus", name="2019-nCoV"),
         assembly_accession="GCA_009948555.1",
         circ_seqs=character(0))
)

