% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BackgroundSubtractionFunctions.R
\docType{methods}
\name{getBackground,RccSet-method}
\alias{getBackground,RccSet-method}
\alias{getBackground}
\title{Get background estimates for a NanoString RccSet}
\usage{
\S4method{getBackground}{RccSet}(rccSet, bgReference = c("both", "blanks",
  "negatives"), summaryFunction = "median", stringency = 0,
  nSolverBackground.shrink = TRUE, nSolverBackground.w1 = 2.18,
  inputMatrix = c("posCtrlData", "exprs"))
}
\arguments{
\item{rccSet}{NanoString RccSet object.}

\item{bgReference}{Measurements to use for background estimates: one of "blanks" (for blank
samples), "negatives" (for negative control probes), or "both". Blanks are
assumed to be indicated as in the description above.}

\item{summaryFunction}{Summary function for background measurements (e.g. "mean" or "median").
User-defined functions similar to these can be specified here as well.}

\item{stringency}{Factor by which deviation (SD or MAD) of the summarization output will be
multiplied to obtain final background estimates.}

\item{nSolverBackground.shrink}{Value to use for the 'shrink' argument to nSolverBackground().}

\item{nSolverBackground.w1}{Value to use for the 'w1' argument to nSolverBackground().}

\item{inputMatrix}{Name of the matrix in the RccSet's assayData to use as input for calculating
background estimates (one of "exprs" or "posCtrlData"). If posCtrlData is
specified but not present in the assayData, an error will be generated.}
}
\value{
A matrix containing background estimates for a NanoString RccSet object.
}
\description{
Returns background estimates for a NanoString RccSet object. The function
depends upon correct annotation in the RccSet: if the \code{bgReference}
argument is set to \code{"blanks"}, it expects blank measurements (i.e.,
water runs) to have their phenoData SampleType set to the value indicating
blanks or an error will be thrown. (See getBlankLabel(); normally this value
would have been set using an argument to newRccSet()). If \code{bgReference} is set to
\code{"negatives"}, then it expects to find the negative control probes via
CodeClass == "Negative". If set to \code{"both"}, it expects both of the above and
will calculate initial background estimates using an algorithm that mimics
the implementation in NanoString's nSolver Analysis Software (see the
nSolverBackground() man page for details on the algorithm).
}
\examples{

data(example_rccSet)

## Calculate probe-specific background based on negative control probes
bg <- getBackground(example_rccSet, bgReference="negatives", summaryFunction="mean",
    inputMatrix="exprs")

## Calculate sample-specific background based on blanks
bg <- getBackground(example_rccSet, bgReference="blanks", inputMatrix="exprs")

## Calculate background that is both sample- and probe-specific
bg <- getBackground(example_rccSet, bgReference="both", stringency=1,
    inputMatrix="exprs")

}
\seealso{
\code{\link{subtractBackground}}
}
\author{
Dorothee Nickles
}
