% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/populate.R
\name{create_env}
\alias{create_env}
\alias{populate_env}
\title{Create or populate an environment with parametrized active bindings}
\usage{
create_env(names, fun, ..., .envir = parent.frame(),
  .enclos = parent.frame())

populate_env(env, names, fun, ..., .envir = parent.frame())
}
\arguments{
\item{names}{A \link{name}, or a list of names, or a character vector; in the latter case
the names are mangled if they are not representable in the native encoding}

\item{fun}{A \link{function} with at least one argument, which will be called
to compute the value of a binding.  The function will be called with the
binding name as first argument (unnamed), and \code{...} as additional arguments}

\item{...}{Additional arguments to \code{fun}}

\item{.envir}{The \link{environment} in which \code{fun} will be executed,
important if \code{fun} calls other functions that are not globally visible}

\item{.enclos}{The enclosing environment (\code{parent.env}) for the newly created environment}

\item{env}{An environment}
}
\description{
Leverages \link[base:bindenv]{makeActiveBinding()}
by allowing parametrized functions
that take the name of the binding and an arbitrary number of additional arguments.
}
\examples{
env <- create_env(letters, paste0, "-lowercase")
env$a
env$c
env$Z
populate_env(env, LETTERS, paste0, "-uppercase")
env$a
env$Z
}
