% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/request.R
\name{webfakes_request}
\alias{webfakes_request}
\title{A webfakes request object}
\description{
webfakes creates a \code{webfakes_request} object for every incoming HTTP
request. This object is passed to every matched route and middleware,
until the response is sent. It has reference semantics, so handlers
can modify it.
}
\details{
Fields and methods:
\itemize{
\item \code{app}: The \code{webfakes_app} object itself.
\item \code{headers}: Named list of HTTP request headers.
\item \code{hostname}: The Host header, the server hostname and maybe port.
\item \code{method}: HTTP method.
\item \code{path}: Server path.
\item \code{protocol}: \code{"http"} or \code{"https"}.
\item \code{query_string}: The raw query string, without the starting \verb{?}.
\item \code{query}: Parsed query parameters in a named list.
\item \code{remote_addr}: String, the domain name or IP address of the client.
webfakes runs on the localhost, so this is \verb{127.0.0.1}.
\item \code{url}: The full URL of the request.
\item \code{get_header(field)}: Function to query a request header. Returns
\code{NULL} if the header is not present.
}

Body parsing middleware adds additional fields to the request object.
See \code{\link[=mw_raw]{mw_raw()}}, \code{\link[=mw_text]{mw_text()}}, \code{\link[=mw_json]{mw_json()}}, \code{\link[=mw_multipart]{mw_multipart()}} and
\code{\link[=mw_urlencoded]{mw_urlencoded()}}.
}
\examples{
# This is how you can see the request and response objects:
app <- new_app()
app$get("/", function(req, res) {
  browser()
  res$send("done")
})
app

# Now start this app on a port:
# app$listen(3000)
# and connect to it from a web browser: http://127.0.0.1:3000
# You can also use another R session to connect:
# httr::GET("http://127.0.0.1:3000")
# or the command line curl tool:
# curl -v http://127.0.0.1:3000
# The app will stop while processing the request.
}
\seealso{
\link{webfakes_response} for the webfakes response object.
}
