/*
 * Copyright (c) 2016-present, RxJava Contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is
 * distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See
 * the License for the specific language governing permissions and limitations under the License.
 */

package io.reactivex.rxjava3.core;

/**
 * Represents the options for applying backpressure to a source sequence.
 */
public enum BackpressureStrategy {
    /**
     * The {@code onNext} events are written without any buffering or dropping.
     * Downstream has to deal with any overflow.
     * <p>Useful when one applies one of the custom-parameter onBackpressureXXX operators.
     */
    MISSING,
    /**
     * Signals a {@link io.reactivex.rxjava3.exceptions.MissingBackpressureException MissingBackpressureException}
     * in case the downstream can't keep up.
     */
    ERROR,
    /**
     * Buffers <em>all</em> {@code onNext} values until the downstream consumes it.
     */
    BUFFER,
    /**
     * Drops the most recent {@code onNext} value if the downstream can't keep up.
     */
    DROP,
    /**
     * Keeps only the latest {@code onNext} value, overwriting any previous value if the
     * downstream can't keep up.
     */
    LATEST
}
