/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;
import org.jmol.util.Logger;

final class Line3D {
    Graphics3D g3d;
    BitSet lineBits;
    float slope;
    boolean lineTypeX;
    int nBits;
    int nCached = 0;
    int nFound = 0;
    Hashtable lineCache = new Hashtable();
    Float slopeKey;
    static final int VISIBILITY_UNCLIPPED = 0;
    static final int VISIBILITY_CLIPPED = 1;
    static final int VISIBILITY_OFFSCREEN = 2;
    int x1t;
    int y1t;
    int z1t;
    int x2t;
    int y2t;
    int z2t;
    int cc1;
    int cc2;

    Line3D(Graphics3D graphics3D) {
        this.g3d = graphics3D;
    }

    void setLineBits(float f, float f2) {
        this.slope = f != 0.0f ? f2 / f : (f2 >= 0.0f ? Float.MAX_VALUE : -3.4028235E38f);
        boolean bl = this.lineTypeX = this.slope <= 1.0f && this.slope >= -1.0f;
        if (this.getCachedLine()) {
            return;
        }
        this.nBits = this.lineTypeX ? this.g3d.width : this.g3d.height;
        this.lineBits = new BitSet(this.nBits);
        if ((f2 = Math.abs(f2)) > (f = Math.abs(f))) {
            float f3 = f;
            f = f2;
            f2 = f3;
        }
        int n = 0;
        float f4 = f + f;
        float f5 = f2 + f2;
        for (int i = 0; i < this.nBits; ++i) {
            if (!((float)(n = (int)((float)n + f5)) > f)) continue;
            this.lineBits.set(i);
            n = (int)((float)n - f4);
        }
        this.lineCache.put(this.slopeKey, this.lineBits);
        ++this.nCached;
    }

    boolean getCachedLine() {
        this.slopeKey = new Float(this.slope);
        if (!this.lineCache.containsKey(this.slopeKey)) {
            return false;
        }
        this.lineBits = (BitSet)this.lineCache.get(this.slopeKey);
        ++this.nFound;
        if (this.nFound == 1000000 && Logger.debugging) {
            Logger.debug("nCached/nFound lines: " + this.nCached + " " + this.nFound);
        }
        return true;
    }

    int getTrimmedLine() {
        this.cc1 = this.g3d.clipCode(this.x1t, this.y1t, this.z1t);
        this.cc2 = this.g3d.clipCode(this.x2t, this.y2t, this.z2t);
        if ((this.cc1 | this.cc2) == 0) {
            return 0;
        }
        int n = this.g3d.xLast;
        int n2 = this.g3d.yLast;
        int n3 = this.g3d.slab;
        int n4 = this.g3d.depth;
        do {
            if ((this.cc1 & this.cc2) != 0) {
                return 2;
            }
            float f = this.x2t - this.x1t;
            float f2 = this.y2t - this.y1t;
            float f3 = this.z2t - this.z1t;
            if (this.cc1 != 0) {
                if ((this.cc1 & 8) != 0) {
                    this.y1t = (int)((float)this.y1t + (float)(-this.x1t) * f2 / f);
                    this.z1t = (int)((float)this.z1t + (float)(-this.x1t) * f3 / f);
                    this.x1t = 0;
                } else if ((this.cc1 & 4) != 0) {
                    this.y1t = (int)((float)this.y1t + (float)(n - this.x1t) * f2 / f);
                    this.z1t = (int)((float)this.z1t + (float)(n - this.x1t) * f3 / f);
                    this.x1t = n;
                } else if ((this.cc1 & 2) != 0) {
                    this.x1t = (int)((float)this.x1t + (float)(-this.y1t) * f / f2);
                    this.z1t = (int)((float)this.z1t + (float)(-this.y1t) * f3 / f2);
                    this.y1t = 0;
                } else if ((this.cc1 & 1) != 0) {
                    this.x1t = (int)((float)this.x1t + (float)(n2 - this.y1t) * f / f2);
                    this.z1t = (int)((float)this.z1t + (float)(n2 - this.y1t) * f3 / f2);
                    this.y1t = n2;
                } else if ((this.cc1 & 0x20) != 0) {
                    this.x1t = (int)((float)this.x1t + (float)(n3 - this.z1t) * f / f3);
                    this.y1t = (int)((float)this.y1t + (float)(n3 - this.z1t) * f2 / f3);
                    this.z1t = n3;
                } else {
                    this.x1t = (int)((float)this.x1t + (float)(n4 - this.z1t) * f / f3);
                    this.y1t = (int)((float)this.y1t + (float)(n4 - this.z1t) * f2 / f3);
                    this.z1t = n4;
                }
                this.cc1 = this.g3d.clipCode(this.x1t, this.y1t, this.z1t);
                continue;
            }
            if ((this.cc2 & 8) != 0) {
                this.y2t = (int)((float)this.y2t + (float)(-this.x2t) * f2 / f);
                this.z2t = (int)((float)this.z2t + (float)(-this.x2t) * f3 / f);
                this.x2t = 0;
            } else if ((this.cc2 & 4) != 0) {
                this.y2t = (int)((float)this.y2t + (float)(n - this.x2t) * f2 / f);
                this.z2t = (int)((float)this.z2t + (float)(n - this.x2t) * f3 / f);
                this.x2t = n;
            } else if ((this.cc2 & 2) != 0) {
                this.x2t = (int)((float)this.x2t + (float)(-this.y2t) * f / f2);
                this.z2t = (int)((float)this.z2t + (float)(-this.y2t) * f3 / f2);
                this.y2t = 0;
            } else if ((this.cc2 & 1) != 0) {
                this.x2t = (int)((float)this.x2t + (float)(n2 - this.y2t) * f / f2);
                this.z2t = (int)((float)this.z2t + (float)(n2 - this.y2t) * f3 / f2);
                this.y2t = n2;
            } else if ((this.cc2 & 0x20) != 0) {
                this.x2t = (int)((float)this.x2t + (float)(n3 - this.z2t) * f / f3);
                this.y2t = (int)((float)this.y2t + (float)(n3 - this.z2t) * f2 / f3);
                this.z2t = n3;
            } else {
                this.x2t = (int)((float)this.x2t + (float)(n4 - this.z2t) * f / f3);
                this.y2t = (int)((float)this.y2t + (float)(n4 - this.z2t) * f2 / f3);
                this.z2t = n4;
            }
            this.cc2 = this.g3d.clipCode(this.x2t, this.y2t, this.z2t);
        } while ((this.cc1 | this.cc2) != 0);
        return 1;
    }

    void plotLine(int n, boolean bl, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl3) {
        this.x1t = n3;
        this.x2t = n6;
        this.y1t = n4;
        this.y2t = n7;
        this.z1t = n5;
        this.z2t = n8;
        if (bl3) {
            switch (this.getTrimmedLine()) {
                case 0: {
                    bl3 = false;
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.plotLineClipped(n, bl, n2, bl2, n3, n4, n5, n6 - n3, n7 - n4, n8 - n5, bl3, 0, 0);
    }

    void plotLineDelta(int n, boolean bl, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl3) {
        this.x1t = n3;
        this.x2t = n3 + n6;
        this.y1t = n4;
        this.y2t = n4 + n7;
        this.z1t = n5;
        this.z2t = n5 + n8;
        if (bl3) {
            switch (this.getTrimmedLine()) {
                case 2: {
                    return;
                }
                case 0: {
                    bl3 = false;
                }
            }
        }
        this.plotLineClipped(n, bl, n2, bl2, n3, n4, n5, n6, n7, n8, bl3, 0, 0);
    }

    void plotLineDelta(int[] nArray, boolean bl, int[] nArray2, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl3) {
        this.x1t = n2;
        this.x2t = n2 + n5;
        this.y1t = n3;
        this.y2t = n3 + n6;
        this.z1t = n4;
        this.z2t = n4 + n7;
        if (bl3) {
            switch (this.getTrimmedLine()) {
                case 2: {
                    return;
                }
                case 0: {
                    bl3 = false;
                }
            }
        }
        this.plotLineClipped(nArray, bl, nArray2, bl2, n, n2, n3, n4, n5, n6, n7, bl3, 0, 0);
    }

    void plotLineDeltaBits(int[] nArray, boolean bl, int[] nArray2, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl3) {
        this.x1t = n2;
        this.x2t = n2 + n5;
        this.y1t = n3;
        this.y2t = n3 + n6;
        this.z1t = n4;
        this.z2t = n4 + n7;
        if (bl3 && this.getTrimmedLine() == 2) {
            return;
        }
        this.plotLineClippedBits(nArray, bl, nArray2, bl2, n, n2, n3, n4, n5, n6, n7, 0, 0);
    }

    void plotDashedLine(int n, boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, boolean bl2) {
        this.x1t = n4;
        this.x2t = n7;
        this.y1t = n5;
        this.y2t = n8;
        this.z1t = n6;
        this.z2t = n9;
        if (bl2) {
            switch (this.getTrimmedLine()) {
                case 2: {
                    return;
                }
                case 0: {
                    bl2 = false;
                }
            }
        }
        this.plotLineClipped(n, bl, n, bl, n4, n5, n6, n7 - n4, n8 - n5, n9 - n6, bl2, n2, n3);
    }

    private void plotLineClipped(int n, boolean bl, int n2, boolean bl2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl3, int n9, int n10) {
        int[] nArray = this.g3d.zbuf;
        int n11 = this.g3d.width;
        int n12 = 0;
        if (n9 == 0) {
            n10 = Integer.MAX_VALUE;
            n9 = 1;
        }
        int n13 = n4 * n11 + n3;
        int n14 = this.g3d.bufferSize;
        boolean bl4 = ((n3 ^ n4) & 1) != 0;
        boolean bl5 = bl;
        int n15 = n;
        if (!(n15 == 0 || bl3 || n13 < 0 || n13 >= n14 || n5 >= nArray[n13] || bl5 && !(bl4 = !bl4))) {
            this.g3d.addPixel(n13, n5, n15);
        }
        if (n6 == 0 && n7 == 0) {
            return;
        }
        int n16 = 1;
        int n17 = n11;
        int n18 = n3 + n6;
        int n19 = n4 + n7;
        if (n6 < 0) {
            n6 = -n6;
            n16 = -1;
        }
        if (n7 < 0) {
            n7 = -n7;
            n17 = -n11;
        }
        int n20 = n6 + n6;
        int n21 = n7 + n7;
        int n22 = n5 << 10;
        if (n7 <= n6) {
            int n23 = n6 - 1;
            if (n8 < 0) {
                n23 = -n23;
            }
            int n24 = ((n8 << 10) + n23) / n6;
            int n25 = 0;
            int n26 = Math.abs(n18 - this.x2t) - 1;
            int n27 = Math.abs(n18 - this.x1t) - 1;
            int n28 = n6 - 1;
            int n29 = n28 / 2;
            while (--n28 >= n26) {
                int n30;
                if (n28 == n29) {
                    bl5 = bl2;
                    n15 = n2;
                    if (n15 == 0) {
                        return;
                    }
                }
                n13 += n16;
                n22 += n24;
                if ((n25 += n21) > n6) {
                    n13 += n17;
                    n25 -= n20;
                    boolean bl6 = bl4 = !bl4;
                }
                if (n15 != 0 && n28 < n27 && n13 >= 0 && n13 < n14 && n12 < n10 && (!bl5 || (bl4 = !bl4)) && (n30 = n22 >> 10) < nArray[n13]) {
                    this.g3d.addPixel(n13, n30, n15);
                }
                n12 = (n12 + 1) % n9;
            }
        } else {
            int n31 = n7 - 1;
            if (n8 < 0) {
                n31 = -n31;
            }
            int n32 = ((n8 << 10) + n31) / n7;
            int n33 = 0;
            int n34 = Math.abs(n19 - this.y2t) - 1;
            int n35 = Math.abs(n19 - this.y1t) - 1;
            int n36 = n7 - 1;
            int n37 = n36 / 2;
            while (--n36 >= n34) {
                int n38;
                if (n36 == n37) {
                    bl5 = bl2;
                    n15 = n2;
                    if (n15 == 0) {
                        return;
                    }
                }
                n13 += n17;
                n22 += n32;
                if ((n33 += n20) > n7) {
                    n13 += n16;
                    n33 -= n21;
                    boolean bl7 = bl4 = !bl4;
                }
                if (n15 != 0 && n36 < n35 && n13 >= 0 && n13 < n14 && n12 < n10 && (!bl5 || (bl4 = !bl4)) && (n38 = n22 >> 10) < nArray[n13]) {
                    this.g3d.addPixel(n13, n38, n15);
                }
                n12 = (n12 + 1) % n9;
            }
        }
    }

    private void plotLineClipped(int[] nArray, boolean bl, int[] nArray2, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl3, int n8, int n9) {
        boolean bl4;
        int[] nArray3 = this.g3d.zbuf;
        int n10 = this.g3d.width;
        int n11 = 0;
        if (n8 == 0) {
            n9 = Integer.MAX_VALUE;
            n8 = 1;
        }
        int n12 = n3 * n10 + n2;
        int n13 = this.g3d.bufferSize;
        int n14 = n < 63 ? n + 1 : n;
        int n15 = n > 0 ? n - 1 : n;
        int n16 = nArray[n];
        int n17 = nArray[n14];
        int n18 = nArray[n15];
        int n19 = nArray2[n];
        int n20 = nArray2[n14];
        int n21 = nArray2[n15];
        int n22 = n16;
        boolean bl5 = bl;
        boolean bl6 = bl4 = ((n2 ^ n3) & 1) != 0;
        if (!(n22 == 0 || bl3 || n12 < 0 || n12 >= n13 || n4 >= nArray3[n12] || bl5 && !(bl4 = !bl4))) {
            this.g3d.addPixel(n12, n4, n22);
        }
        if (n5 == 0 && n6 == 0) {
            return;
        }
        int n23 = 1;
        int n24 = n10;
        int n25 = n2 + n5;
        int n26 = n3 + n6;
        if (n5 < 0) {
            n5 = -n5;
            n23 = -1;
        }
        if (n6 < 0) {
            n6 = -n6;
            n24 = -n10;
        }
        int n27 = n5 + n5;
        int n28 = n6 + n6;
        int n29 = n4 << 10;
        int n30 = n17;
        int n31 = n18;
        if (n6 <= n5) {
            int n32 = n5 - 1;
            if (n7 < 0) {
                n32 = -n32;
            }
            int n33 = ((n7 << 10) + n32) / n5;
            int n34 = 0;
            int n35 = Math.abs(n25 - this.x2t) - 1;
            int n36 = Math.abs(n25 - this.x1t) - 1;
            int n37 = n5 - 1;
            int n38 = n37 / 2;
            while (--n37 >= n35) {
                int n39;
                int n40;
                if (n37 == n38) {
                    n22 = n19;
                    if (n22 == 0) {
                        return;
                    }
                    n30 = n20;
                    n31 = n21;
                    bl5 = bl2;
                    if (bl5 && !bl) {
                        n40 = n12 % n10;
                        n39 = n12 / n10;
                        bl4 = ((n40 ^ n39) & 1) == 0;
                    }
                }
                n12 += n23;
                n29 += n33;
                if ((n34 += n28) > n5) {
                    n12 += n24;
                    n34 -= n27;
                    boolean bl7 = bl4 = !bl4;
                }
                if (n22 != 0 && n37 < n36 && n12 >= 0 && n12 < n13 && n11 < n9 && (!bl5 || (bl4 = !bl4)) && (n39 = n29 >> 10) < nArray3[n12]) {
                    n40 = Shade3D.nextRandom8Bit();
                    this.g3d.addPixel(n12, n39, n40 < 85 ? n31 : (n40 > 170 ? n30 : n22));
                }
                n11 = (n11 + 1) % n8;
            }
        } else {
            int n41 = n6 - 1;
            if (n7 < 0) {
                n41 = -n41;
            }
            int n42 = ((n7 << 10) + n41) / n6;
            int n43 = 0;
            int n44 = Math.abs(n26 - this.y2t) - 1;
            int n45 = Math.abs(n26 - this.y1t) - 1;
            int n46 = n6 - 1;
            int n47 = n46 / 2;
            while (--n46 >= n44) {
                int n48;
                int n49;
                if (n46 == n47) {
                    n22 = n19;
                    if (n22 == 0) {
                        return;
                    }
                    n30 = n20;
                    n31 = n21;
                    bl5 = bl2;
                    if (bl5 && !bl) {
                        n49 = n12 % n10;
                        n48 = n12 / n10;
                        bl4 = ((n49 ^ n48) & 1) == 0;
                    }
                }
                n12 += n24;
                n29 += n42;
                if ((n43 += n27) > n6) {
                    n12 += n23;
                    n43 -= n28;
                    boolean bl8 = bl4 = !bl4;
                }
                if (n22 != 0 && n46 < n45 && n12 >= 0 && n12 < n13 && n11 < n9 && (!bl5 || (bl4 = !bl4)) && (n48 = n29 >> 10) < nArray3[n12]) {
                    n49 = Shade3D.nextRandom8Bit();
                    this.g3d.addPixel(n12, n48, n49 < 85 ? n31 : (n49 > 170 ? n30 : n22));
                }
                n11 = (n11 + 1) % n8;
            }
        }
    }

    private void plotLineClippedBits(int[] nArray, boolean bl, int[] nArray2, boolean bl2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        float f;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int[] nArray3 = this.g3d.zbuf;
        int n17 = this.g3d.width;
        int n18 = 0;
        if (n8 == 0) {
            n9 = Integer.MAX_VALUE;
            n8 = 1;
        }
        int n19 = n < 63 ? n + 1 : n;
        int n20 = n > 0 ? n - 1 : n;
        int n21 = nArray[n];
        int n22 = nArray[n19];
        int n23 = nArray[n20];
        int n24 = nArray2[n];
        int n25 = nArray2[n19];
        int n26 = nArray2[n20];
        boolean bl3 = bl;
        boolean bl4 = ((n2 ^ n3) & 1) != 0;
        int n27 = n3 * n17 + n2;
        int n28 = this.g3d.bufferSize;
        if (this.lineTypeX) {
            n16 = n2;
            n15 = this.x1t;
            n14 = this.x2t;
            n13 = n2 + n5 / 2;
            n11 = n12 = n5 >= 0 ? 1 : -1;
            n10 = n6 >= 0 ? n17 : -n17;
            f = (float)n7 / (float)Math.abs(n5);
        } else {
            n16 = n3;
            n15 = this.y1t;
            n14 = this.y2t;
            n13 = n3 + n6 / 2;
            n12 = n6 >= 0 ? 1 : -1;
            n11 = n6 >= 0 ? n17 : -n17;
            n10 = n5 >= 0 ? 1 : -1;
            f = (float)n7 / (float)Math.abs(n6);
        }
        float f2 = n4;
        int n29 = n21;
        int n30 = n22;
        int n31 = n23;
        boolean bl5 = false;
        int n32 = n16;
        int n33 = n16;
        while (true) {
            int n34;
            if (n32 == n15) {
                bl5 = true;
            }
            if (n32 == n13) {
                n29 = n24;
                if (n29 == 0) {
                    return;
                }
                n30 = n25;
                n31 = n26;
                bl3 = bl2;
                if (bl3 && !bl) {
                    int n35 = n27 % n17;
                    n34 = n27 / n17;
                    boolean bl6 = bl4 = ((n35 ^ n34) & 1) == 0;
                }
            }
            if (n29 != 0 && bl5 && n27 >= 0 && n27 < n28 && n18 < n9 && (!bl3 || (bl4 = !bl4)) && f2 < (float)nArray3[n27]) {
                n34 = Shade3D.nextRandom8Bit();
                this.g3d.addPixel(n27, (int)f2, n34 < 85 ? n31 : (n34 > 170 ? n30 : n29));
            }
            if (n32 == n14) break;
            n18 = (n18 + 1) % n8;
            n27 += n11;
            while (n33 < 0) {
                n33 += this.nBits;
            }
            if (this.lineBits.get(n33 % this.nBits)) {
                n27 += n10;
            }
            f2 += f;
            n32 += n12;
            n33 += n12;
        }
    }
}

