/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMolecule;

public class SmilesParser {
    private SmilesBond[] ringBonds = null;

    public SmilesMolecule parseSmiles(String string) throws InvalidSmilesException {
        int n;
        if (string == null) {
            throw new InvalidSmilesException("SMILES expressions must not be null");
        }
        SmilesMolecule smilesMolecule = new SmilesMolecule();
        this.parseSmiles(smilesMolecule, string, null);
        for (n = 0; n < smilesMolecule.getAtomsCount(); ++n) {
            SmilesAtom smilesAtom = smilesMolecule.getAtom(n);
            smilesAtom.createMissingHydrogen(smilesMolecule);
        }
        if (this.ringBonds != null) {
            for (n = 0; n < this.ringBonds.length; ++n) {
                if (this.ringBonds[n] == null) continue;
                throw new InvalidSmilesException("Open ring");
            }
        }
        return smilesMolecule;
    }

    private void parseSmiles(SmilesMolecule smilesMolecule, String string, SmilesAtom smilesAtom) throws InvalidSmilesException {
        String string2;
        int n;
        int n2;
        if (string == null || string.length() == 0) {
            return;
        }
        int n3 = 0;
        char c = string.charAt(n3);
        if (c == '(') {
            n2 = 1;
            block4: for (n = ++n3; n < string.length() && n2 > 0; ++n) {
                switch (string.charAt(n)) {
                    case '(': {
                        ++n2;
                        continue block4;
                    }
                    case ')': {
                        --n2;
                    }
                }
            }
            if (n2 != 0) {
                throw new InvalidSmilesException("Unbalanced parenthesis");
            }
            string2 = string.substring(n3, n - 1);
            this.parseSmiles(smilesMolecule, string2, smilesAtom);
            n3 = n;
            if (n3 >= string.length()) {
                throw new InvalidSmilesException("Pattern must not end with ')'");
            }
        }
        if ((n = SmilesBond.getBondTypeFromCode(c = string.charAt(n3))) != -1) {
            if (smilesAtom == null) {
                throw new InvalidSmilesException("Bond without a previous atom");
            }
            ++n3;
        }
        if ((c = string.charAt(n3)) >= '0' && c <= '9') {
            String string3 = string.substring(n3, n3 + 1);
            this.parseRing(smilesMolecule, string3, smilesAtom, n);
            ++n3;
        } else if (c == '%') {
            if (string.charAt(++n3) < '\u0000' || string.charAt(n3) > '\t') {
                throw new InvalidSmilesException("Ring number must follow the % sign");
            }
            for (n2 = n3; n2 < string.length() && string.charAt(n2) >= '0' && string.charAt(n2) <= '9'; ++n2) {
            }
            string2 = string.substring(n3, n2);
            this.parseRing(smilesMolecule, string2, smilesAtom, n);
            n3 = n2;
        } else if (c == '[') {
            for (n2 = ++n3; n2 < string.length() && string.charAt(n2) != ']'; ++n2) {
            }
            if (n2 >= string.length()) {
                throw new InvalidSmilesException("Unmatched [");
            }
            string2 = string.substring(n3, n2);
            smilesAtom = this.parseAtom(smilesMolecule, string2, smilesAtom, n, true);
            n3 = n2 + 1;
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '*') {
            n2 = 1;
            if (n3 + 1 < string.length()) {
                char c2 = string.charAt(n3 + 1);
                if (c >= 'A' && c <= 'Z' && c2 >= 'a' && c2 <= 'z') {
                    n2 = 2;
                }
            }
            string2 = string.substring(n3, n3 + n2);
            smilesAtom = this.parseAtom(smilesMolecule, string2, smilesAtom, n, false);
            n3 += n2;
        }
        if (n3 == 0) {
            throw new InvalidSmilesException("Unexpected character: " + string.charAt(0));
        }
        if (n3 < string.length()) {
            String string4 = string.substring(n3);
            this.parseSmiles(smilesMolecule, string4, smilesAtom);
        }
    }

    private SmilesAtom parseAtom(SmilesMolecule smilesMolecule, String string, SmilesAtom smilesAtom, int n, boolean bl) throws InvalidSmilesException {
        String string2;
        int n2;
        int n3;
        int n4;
        if (string == null || string.length() == 0) {
            throw new InvalidSmilesException("Empty atom definition");
        }
        int n5 = 0;
        char c = string.charAt(n5);
        int n6 = Integer.MIN_VALUE;
        if (c >= '0' && c <= '9') {
            for (n4 = n5; n4 < string.length() && string.charAt(n4) >= '0' && string.charAt(n4) <= '9'; ++n4) {
            }
            String string3 = string.substring(n5, n4);
            try {
                n6 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new InvalidSmilesException("Non numeric atomic mass");
            }
            n5 = n4;
        }
        if (n5 >= string.length()) {
            throw new InvalidSmilesException("Missing atom symbol");
        }
        c = string.charAt(n5);
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '*')) {
            throw new InvalidSmilesException("Unexpected atom symbol");
        }
        n4 = 1;
        if (n5 + 1 < string.length()) {
            char c2 = string.charAt(n5 + 1);
            if (c >= 'A' && c <= 'Z' && c2 >= 'a' && c2 <= 'z') {
                n4 = 2;
            }
        }
        String string4 = string.substring(n5, n5 + n4);
        String string5 = null;
        int n7 = Integer.MIN_VALUE;
        if ((n5 += n4) < string.length() && (c = string.charAt(n5)) == '@') {
            if (++n5 < string.length()) {
                c = string.charAt(n5);
                if (c == '@') {
                    ++n5;
                    string5 = "";
                    n7 = 2;
                } else if (c >= 'A' && c <= 'Z' && c != 'H') {
                    if (n5 + 1 < string.length() && (n3 = (int)string.charAt(n5)) >= 65 && n3 <= 90) {
                        string5 = string.substring(n5, n5 + 2);
                        for (n2 = n5 += 2; n2 < string.length() && string.charAt(n2) >= '0' && string.charAt(n2) <= '9'; ++n2) {
                        }
                        if (n2 > n5) {
                            string2 = string.substring(n5, n2);
                            try {
                                n7 = Integer.parseInt(string2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw new InvalidSmilesException("Non numeric chiral order");
                            }
                        } else {
                            n7 = 1;
                        }
                        n5 = n2;
                    }
                } else {
                    string5 = "";
                    n7 = 1;
                }
            } else {
                string5 = "";
                n7 = 1;
            }
        }
        n3 = Integer.MIN_VALUE;
        if (n5 < string.length() && (c = string.charAt(n5)) == 'H') {
            for (n2 = ++n5; n2 < string.length() && string.charAt(n2) >= '0' && string.charAt(n2) <= '9'; ++n2) {
            }
            if (n2 > n5) {
                string2 = string.substring(n5, n2);
                try {
                    n3 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidSmilesException("Non numeric hydrogen count");
                }
            } else {
                n3 = 1;
            }
            n5 = n2;
        }
        if (n3 == Integer.MIN_VALUE && bl) {
            n3 = 0;
        }
        n2 = 0;
        if (n5 < string.length() && ((c = string.charAt(n5)) == '+' || c == '-')) {
            int n8 = 1;
            if (++n5 < string.length()) {
                char c3 = string.charAt(n5);
                if (c3 >= '0' && c3 <= '9') {
                    int n9;
                    for (n9 = n5; n9 < string.length() && string.charAt(n9) >= '0' && string.charAt(n9) <= '9'; ++n9) {
                    }
                    String string6 = string.substring(n5, n9);
                    try {
                        n8 = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new InvalidSmilesException("Non numeric charge");
                    }
                    n5 = n9;
                } else {
                    int n10 = n5;
                    while (n10 < string.length() && string.charAt(n10) == c) {
                        ++n10;
                        ++n8;
                    }
                    n5 = n10;
                }
            }
            n2 = c == '+' ? n8 : -n8;
        }
        if (n5 < string.length()) {
            throw new InvalidSmilesException("Unexpected characters after atom definition: " + string.substring(n5));
        }
        if (n == -1) {
            n = 1;
        }
        SmilesAtom smilesAtom2 = smilesMolecule.createAtom();
        if (smilesAtom != null && n != 0) {
            smilesMolecule.createBond(smilesAtom, smilesAtom2, n);
        }
        smilesAtom2.setSymbol(string4);
        smilesAtom2.setAtomicMass(n6);
        smilesAtom2.setCharge(n2);
        smilesAtom2.setChiralClass(string5);
        smilesAtom2.setChiralOrder(n7);
        smilesAtom2.setHydrogenCount(n3);
        return smilesAtom2;
    }

    private void parseRing(SmilesMolecule smilesMolecule, String string, SmilesAtom smilesAtom, int n) throws InvalidSmilesException {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidSmilesException("Non numeric ring identifier");
        }
        if (this.ringBonds == null) {
            this.ringBonds = new SmilesBond[10];
            for (int i = 0; i < this.ringBonds.length; ++i) {
                this.ringBonds[i] = null;
            }
        }
        if (n2 >= this.ringBonds.length) {
            int n3;
            SmilesBond[] smilesBondArray = new SmilesBond[n2 + 1];
            for (n3 = 0; n3 < this.ringBonds.length; ++n3) {
                smilesBondArray[n3] = this.ringBonds[n3];
            }
            for (n3 = this.ringBonds.length; n3 < smilesBondArray.length; ++n3) {
                smilesBondArray[n3] = null;
            }
        }
        if (this.ringBonds[n2] == null) {
            this.ringBonds[n2] = smilesMolecule.createBond(smilesAtom, null, n);
        } else {
            if (n == -1) {
                n = this.ringBonds[n2].getBondType();
                if (n == -1) {
                    n = 1;
                }
            } else if (this.ringBonds[n2].getBondType() != -1 && this.ringBonds[n2].getBondType() != n) {
                throw new InvalidSmilesException("Incoherent bond type for ring");
            }
            this.ringBonds[n2].setBondType(n);
            this.ringBonds[n2].setAtom2(smilesAtom);
            smilesAtom.addBond(this.ringBonds[n2]);
            this.ringBonds[n2] = null;
        }
    }
}

