/* <<< Start of information >>>                                             */
/* This file is part of the xwatch package.                                 */
/* Copyright (C) 1995 Karel Kubat.  All rights reserved.                    */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/*                                                                          */
/* You may link this software with XForms (Copyright (C) by T.C. Zhao and   */
/* Mark Overmars) and distribute the resulting binary, under the            */
/* restrictions in clause 3 of the GPL, even though the resulting binary is */
/* not, as a whole, covered by the GPL. (You still need a separate license  */
/* to do so from the owner(s) of the copyright for XForms, however).  If a  */
/* derivative no longer requires XForms, you may use the unsupplemented GPL */
/* as its license by deleting this paragraph and therefore removing this    */
/* exemption for XForms.                                                    */
/*                                                                          */
/* This program is distributed in the hope that it will be useful,          */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/* GNU General Public License for more details.                             */
/*                                                                          */
/* You should have received a copy of the GNU General Public License        */
/* along with this program; if not, write to the Free Software              */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA */
/* <<< End of information >>>                                               */

#include "xwatch.h"

void addfile (char *filename)
{
    struct stat
	statbuf;
    char
	buf [512],
        fname [1000],
	*cp;
    FILE
	*f;
    int
	i,
	inode,
	readres,
	colorindex;
        
    colorindex = foregr;                                /* assume std foregr */
    
    cp = strchr (filename, ':');                        /* try to split name */
    if (cp)
    {
        *cp = '\0';                                     /* cut off : part */
        cp++;                                           /* cp points to */
        if (! *cp)                                      /* color info */
            cp = NULL;
    }
        
    strcpy (fname, filename);                           /* get filename */
    if (cp)                                             /* handle color */
        colorindex = colorname2index (cp);              /* colorspec here */

    if (stat (fname, &statbuf))                         /* see if file */
    {                                                   /* exists */
	if (firstwarnings)
	    warning ("Cannot find %s: %s", fname, strerror (errno));
	return;
    }

    if (! S_ISREG (statbuf.st_mode))                    /* is it ordinary */
    {                                                   /* file */
	if (firstwarnings)
	    warning ("%s is not a regular file", fname);
	return;
    }

    inode = statbuf.st_ino;

    if (! (f = fopen (fname, "r")) )                    /* is it a textfile */
    {
	if (firstwarnings)
	    warning ("Cannot read %s: %s", fname, strerror (errno));
	return;
    }
    readres = fread (buf, 1, sizeof (buf), f);
    for (i = 0; i < readres; i++)
	if (! buf [i])
	{
	    if (firstwarnings)
		warning ("File %s is a binary file", fname);
	    fclose (f);
	    return;
	}
    fclose (f);

    for (i = 0; i < nfinfo; i++)                        /* do we already */
	if (finfo [i].inode == inode)                   /* have the file */
	{
	    if (firstwarnings)
		warning ("Names %s and %s are the the same file",
		     fname, finfo [i].name);
	    return;
	}

    /* after all the checks, add it to our list */
    finfo = (Fileinfo *) xrealloc (finfo, (nfinfo + 1) * sizeof (Fileinfo));
    finfo [nfinfo].name = xstrdup (fname);
    finfo [nfinfo].active = 1;
    finfo [nfinfo].inode = inode;
    finfo [nfinfo].offset = statbuf.st_size;
    finfo [nfinfo].colorindex = colorindex;
    nfinfo++;
}
	
